/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote.strategy;

import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.remote.strategy.ExclusiveReadLockCheck;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpChangedExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<FTPFile> {
    private static final Logger LOG = LoggerFactory.getLogger(FtpChangedExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 5000L;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.WARN;
    private long minLength = 1L;
    private long minAge;
    private boolean fastExistsCheck;

    public void prepareOnStartup(GenericFileOperations<FTPFile> tGenericFileOperations, GenericFileEndpoint<FTPFile> tGenericFileEndpoint) throws Exception {
    }

    public boolean acquireExclusiveReadLock(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
        LOG.trace("Waiting for exclusive read lock to file: {}", file);
        ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationTimeBudget().withMaxDuration(Duration.ofMillis(this.timeout)).withInterval(Duration.ofMillis(this.checkInterval)).build()).withName("ftp-acquire-exclusive-read-lock").build();
        ExclusiveReadLockCheck exclusiveReadLockCheck = new ExclusiveReadLockCheck(this.fastExistsCheck, this.minAge, this.minLength);
        if (!task.run(exchange.getContext(), () -> exclusiveReadLockCheck.tryAcquireExclusiveReadLock(operations, file))) {
            CamelLogger.log((Logger)LOG, (LoggingLevel)this.readLockLoggingLevel, (String)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + String.valueOf(file)));
            return false;
        }
        return true;
    }

    public void releaseExclusiveReadLockOnAbort(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
    }

    public void releaseExclusiveReadLockOnRollback(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
    }

    public void releaseExclusiveReadLockOnCommit(GenericFileOperations<FTPFile> operations, GenericFile<FTPFile> file, Exchange exchange) throws Exception {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    public void setMarkerFiler(boolean markerFiler) {
    }

    public void setDeleteOrphanLockFiles(boolean deleteOrphanLockFiles) {
    }

    public long getMinLength() {
        return this.minLength;
    }

    public void setMinLength(long minLength) {
        this.minLength = minLength;
    }

    public long getMinAge() {
        return this.minAge;
    }

    public void setMinAge(long minAge) {
        this.minAge = minAge;
    }

    public boolean isFastExistsCheck() {
        return this.fastExistsCheck;
    }

    public void setFastExistsCheck(boolean fastExistsCheck) {
        this.fastExistsCheck = fastExistsCheck;
    }
}

