/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker.springboot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.freemarker.FreemarkerComponent;
import org.apache.camel.component.freemarker.springboot.FreemarkerComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, FreemarkerComponentConfiguration.class})
public class FreemarkerComponentAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreemarkerComponentAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private FreemarkerComponentConfiguration configuration;
    @Autowired(required=false)
    private List<ComponentCustomizer<FreemarkerComponent>> customizers;

    @Lazy
    @Bean(name={"freemarker-component"})
    @ConditionalOnMissingBean(value={FreemarkerComponent.class})
    public FreemarkerComponent configureFreemarkerComponent() throws Exception {
        FreemarkerComponent component = new FreemarkerComponent();
        component.setCamelContext(this.camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)((Object)this.configuration), parameters, null, (boolean)false);
        for (Map.Entry entry : parameters.entrySet()) {
            Object value = entry.getValue();
            Class<?> paramClass = value.getClass();
            if (!paramClass.getName().endsWith("NestedConfiguration")) continue;
            Class nestedClass = null;
            try {
                nestedClass = (Class)paramClass.getDeclaredField("CAMEL_NESTED_CLASS").get(null);
                HashMap nestedParameters = new HashMap();
                IntrospectionSupport.getProperties(value, nestedParameters, null, (boolean)false);
                Object nestedProperty = nestedClass.newInstance();
                CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, nestedProperty, nestedParameters, (boolean)false);
                entry.setValue(nestedProperty);
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)component, parameters, (boolean)false);
        if (ObjectHelper.isNotEmpty(this.customizers)) {
            for (ComponentCustomizer componentCustomizer : this.customizers) {
                boolean useCustomizer = componentCustomizer instanceof HasId ? HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.component.customizer", "camel.component.freemarker.customizer", ((HasId)componentCustomizer).getId()}) : HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.component.customizer", "camel.component.freemarker.customizer"});
                if (!useCustomizer) continue;
                LOGGER.debug("Configure component {}, with customizer {}", (Object)component, (Object)componentCustomizer);
                componentCustomizer.customize((Component)component);
            }
        }
        return component;
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.component", "camel.component.freemarker");
        }
    }
}

