package org.apache.camel.component.exec;

import org.apache.camel.Exchange;
import org.apache.camel.TypeConversionException;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.TypeConverterSupport;
import org.apache.camel.util.DoubleMap;

@SuppressWarnings("unchecked")
public class ExecResultConverterLoader implements TypeConverterLoader {


    static abstract class BaseTypeConverter extends TypeConverterSupport {
        private final boolean allowNull;

        public BaseTypeConverter(boolean allowNull) {
            this.allowNull = allowNull;
        }

        @Override
        public boolean allowNull() {
            return allowNull;
        }

        @Override
        public <T> T convertTo(Class<T> type, Exchange exchange, Object value) throws TypeConversionException {
            try {
                return (T) doConvert(exchange, value);
            } catch (TypeConversionException e) {
                throw e;
            } catch (Exception e) {
                throw new TypeConversionException(value, type, e);
            }
        }
        protected abstract Object doConvert(Exchange exchange, Object value) throws Exception;
    };

    private final DoubleMap<Class<?>, Class<?>, BaseTypeConverter> converters = new DoubleMap<>(4);

    public ExecResultConverterLoader() {
    }

    private void registerConverters() {
        converters.put(byte[].class, org.apache.camel.component.exec.ExecResult.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.exec.ExecResultConverter.convertToByteArray((org.apache.camel.component.exec.ExecResult) value, exchange);
            }
        });
        converters.put(java.io.InputStream.class, org.apache.camel.component.exec.ExecResult.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.exec.ExecResultConverter.convertToInputStream((org.apache.camel.component.exec.ExecResult) value);
            }
        });
        converters.put(java.lang.String.class, org.apache.camel.component.exec.ExecResult.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.exec.ExecResultConverter.convertToString((org.apache.camel.component.exec.ExecResult) value, exchange);
            }
        });
        converters.put(org.w3c.dom.Document.class, org.apache.camel.component.exec.ExecResult.class, new BaseTypeConverter(false) {
            @Override
            public Object doConvert(Exchange exchange, Object value) throws Exception {
                return org.apache.camel.component.exec.ExecResultConverter.convertToDocument((org.apache.camel.component.exec.ExecResult) value, exchange);
            }
        });
    }

    @Override
    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        registerConverters();
        converters.forEach((k, v, c) -> registry.addTypeConverter(k, v, c));
    }

}
