/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.websocket;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.websocket.WebsocketComponent;

public class TwitterWebSocketRoute
extends RouteBuilder {
    private int port = 9090;
    private String searchTerm;
    private int delay = 2;
    private String consumerKey;
    private String consumerSecret;
    private String accessToken;
    private String accessTokenSecret;

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenSecret() {
        return this.accessTokenSecret;
    }

    public void setAccessTokenSecret(String accessTokenSecret) {
        this.accessTokenSecret = accessTokenSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(String searchTerm) {
        this.searchTerm = searchTerm;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void configure() throws Exception {
        WebsocketComponent wc = (WebsocketComponent)this.getContext().getComponent("websocket", WebsocketComponent.class);
        wc.setPort(Integer.valueOf(this.port));
        wc.setStaticResources("classpath:.");
        TwitterComponent tc = (TwitterComponent)this.getContext().getComponent("twitter", TwitterComponent.class);
        tc.setAccessToken(this.accessToken);
        tc.setAccessTokenSecret(this.accessTokenSecret);
        tc.setConsumerKey(this.consumerKey);
        tc.setConsumerSecret(this.consumerSecret);
        this.fromF("twitter://search?type=polling&delay=%s&keywords=%s", new Object[]{this.delay, this.searchTerm}).to("websocket:camel-tweet?sendToAll=true");
    }
}

