/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.spring.boot.metrics;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import com.codahale.metrics.graphite.GraphiteUDP;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;

@SpringBootApplication
public class Application {
    private static final Logger LOG = LoggerFactory.getLogger(Application.class);
    @Autowired
    private MetricRegistry metricRegistry;

    public static void main(String[] args) {
        LOG.info(" *** Starting Camel Metrics Example Application ***");
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean(destroyMethod="stop")
    public GraphiteReporter graphiteReporter() {
        GraphiteUDP graphite = new GraphiteUDP(new InetSocketAddress("localhost", 2003));
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith("camel-spring-boot").convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build((GraphiteSender)graphite);
        reporter.start(5L, TimeUnit.SECONDS);
        return reporter;
    }

    @Bean
    public RouteBuilder slowRoute() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    public RouteBuilder fastRoute() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Bean
    CamelContextConfiguration contextConfiguration() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ MetricRegistry access$100(Application x0) {
        return x0.metricRegistry;
    }
}

