/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.jmstofile;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.Component;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.impl.DefaultCamelContext;

public final class CamelJmsToFileExample {
    private CamelJmsToFileExample() {
    }

    public static void main(String[] args) throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
        context.addComponent("test-jms", (Component)JmsComponent.jmsComponentAutoAcknowledge((ConnectionFactory)connectionFactory));
        context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("test-jms:queue:test.queue").to("file://test");
            }
        });
        ProducerTemplate template = context.createProducerTemplate();
        context.start();
        for (int i = 0; i < 10; ++i) {
            template.sendBody("test-jms:queue:test.queue", (Object)("Test Message: " + i));
        }
        Thread.sleep(1000L);
        context.stop();
    }
}

