/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.java8.rx;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.main.Main;
import org.apache.camel.main.MainListener;
import org.apache.camel.main.MainListenerSupport;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.rx.ReactiveCamel;
import rx.Observable;

public class MyApplication
extends Main {
    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.addMainListener((MainListener)new MyCamelContextConfigurer());
        main.addRouteBuilder((RouteBuilder)new MyRouteBuilder());
        main.run(args);
    }

    private static class MyOrder {
        private final String id;
        private final double amount;

        MyOrder(Exchange e) {
            this.amount = (Integer)e.getProperty("CamelTimerCounter", Integer.class) % 5;
            this.id = (String)e.getProperty("CamelTimerCounter", String.class);
        }

        public String toString() {
            return "Order[id " + this.id + ", amount " + this.amount + "]";
        }

        public double getAmount() {
            return this.amount;
        }

        public String getId() {
            return this.id;
        }
    }

    private static class MyCamelContextConfigurer
    extends MainListenerSupport {
        private MyCamelContextConfigurer() {
        }

        public void configure(CamelContext context) {
            ReactiveCamel rx = new ReactiveCamel(context);
            Observable orders = rx.toObservable("seda:orders", MyOrder.class).filter(o -> o.getAmount() > 2.0).map(o -> o.toString());
            rx.sendTo(orders, "seda:large-orders");
        }
    }

    private static class MyRouteBuilder
    extends RouteBuilder {
        private MyRouteBuilder() {
        }

        public void configure() throws Exception {
            ((ProcessorDefinition)this.from("timer:rx?period=1000").routeId("orders").transform().exchange(MyOrder::new)).to("seda:orders");
            this.from("seda:large-orders").routeId("large-orders").log("Got ${body}");
        }
    }
}

