/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.guice.jms;

import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.example.guice.jms.MyRouteBuilder;
import org.apache.camel.example.guice.jms.Printer;
import org.apache.camel.example.guice.jms.SomeBean;
import org.apache.camel.guice.CamelModuleWithMatchingRoutes;
import org.guiceyfruit.jndi.JndiBind;

public class MyModule
extends CamelModuleWithMatchingRoutes {
    protected void configure() {
        super.configure();
        this.bind(MyRouteBuilder.class);
        this.bind(Printer.class);
    }

    @Provides
    @JndiBind(value="jms")
    JmsComponent jms(@Named(value="activemq.brokerURL") String brokerUrl) {
        return JmsComponent.jmsComponent((ConnectionFactory)new ActiveMQConnectionFactory(brokerUrl));
    }

    @Provides
    @JndiBind(value="myBean")
    SomeBean someBean(Injector injector) {
        return (SomeBean)injector.getInstance(SomeBean.class);
    }
}

