/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.guice.jms;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.osgi.CamelContextFactory;
import org.apache.camel.osgi.CompositeRegistry;
import org.apache.camel.spi.Registry;
import org.guiceyfruit.jndi.JndiBindings;
import org.guiceyfruit.jndi.internal.JndiContext;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiCamelContextProvider
implements Provider<CamelContext> {
    private final CamelContextFactory factory = new CamelContextFactory();
    @Inject
    private Set<RoutesBuilder> routeBuilders;
    @Inject
    private Injector injector;

    public OSGiCamelContextProvider(BundleContext context) {
        this.factory.setBundleContext(context);
    }

    protected Context getJndiContext() {
        try {
            JndiContext context = new JndiContext(null);
            if (this.injector != null) {
                JndiBindings.bindInjectorAndBindings((Context)context, (Injector)this.injector, (Properties)new Properties());
            }
            return context;
        }
        catch (Exception e) {
            throw new ProvisionException("Failed to create JNDI bindings. Reason: " + e, (Throwable)e);
        }
    }

    protected void updateRegistry(DefaultCamelContext camelContext) {
        CompositeRegistry compositeRegistry = new CompositeRegistry();
        compositeRegistry.addRegistry((Registry)new JndiRegistry(this.getJndiContext()));
        compositeRegistry.addRegistry(camelContext.getRegistry());
        camelContext.setRegistry((Registry)compositeRegistry);
    }

    public CamelContext get() {
        DefaultCamelContext camelContext = this.factory.createContext();
        if (this.routeBuilders != null) {
            for (RoutesBuilder builder : this.routeBuilders) {
                try {
                    camelContext.addRoutes(builder);
                }
                catch (Exception e) {
                    throw new ProvisionException("Failed to add the router. Reason: " + e, (Throwable)e);
                }
            }
        }
        this.updateRegistry(camelContext);
        return camelContext;
    }
}

