/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.guice.jms;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.CamelContext;
import org.apache.camel.example.guice.jms.MyModule;
import org.apache.camel.example.guice.jms.OSGiCamelContextProvider;
import org.osgi.framework.BundleContext;

public class MyOSGiModule
extends MyModule {
    private OSGiCamelContextProvider provider;
    private Properties properties;

    MyOSGiModule(BundleContext bundleContext) {
        this.provider = new OSGiCamelContextProvider(bundleContext);
        this.properties = new Properties();
        URL jndiPropertiesUrl = null;
        jndiPropertiesUrl = bundleContext != null ? bundleContext.getBundle().getEntry("camel.properties") : ((Object)((Object)this)).getClass().getResource("/camel.properties");
        try {
            if (jndiPropertiesUrl != null) {
                this.properties.load(jndiPropertiesUrl.openStream());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void configureCamelContext() {
        this.bind(CamelContext.class).toProvider((Provider)this.provider).asEagerSingleton();
    }

    protected void configure() {
        Names.bindProperties((Binder)this.binder(), (Properties)this.properties);
        super.configure();
    }
}

