/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.example.gauth;

import com.google.gdata.client.authn.oauth.OAuthHmacSha1Signer;
import com.google.gdata.client.authn.oauth.OAuthParameters;
import com.google.gdata.client.authn.oauth.OAuthSigner;
import com.google.gdata.client.calendar.CalendarService;
import com.google.gdata.data.calendar.CalendarEntry;
import com.google.gdata.data.calendar.CalendarFeed;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TutorialService {
    private Properties credentials;

    public void setCredentials(Properties credentials) {
        this.credentials = credentials;
    }

    public List<String> getCalendarNames(String accessToken, String accessTokenSecret) throws Exception {
        CalendarService calendarService = new CalendarService("apache-camel-2.3");
        OAuthParameters params = this.getOAuthParams(accessToken, accessTokenSecret);
        calendarService.setOAuthCredentials(params, (OAuthSigner)new OAuthHmacSha1Signer());
        URL feedUrl = new URL("http://www.google.com/calendar/feeds/default/");
        CalendarFeed resultFeed = (CalendarFeed)calendarService.getFeed(feedUrl, CalendarFeed.class);
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < resultFeed.getEntries().size(); ++i) {
            CalendarEntry entry = (CalendarEntry)resultFeed.getEntries().get(i);
            result.add(entry.getTitle().getPlainText());
        }
        return result;
    }

    private OAuthParameters getOAuthParams(String accessToken, String accessTokenSecret) {
        OAuthParameters params = new OAuthParameters();
        params.setOAuthConsumerKey(this.credentials.getProperty("consumer.key"));
        params.setOAuthConsumerSecret(this.credentials.getProperty("consumer.secret"));
        params.setOAuthToken(accessToken);
        params.setOAuthTokenSecret(accessTokenSecret);
        return params;
    }
}

