/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.Collections;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchEndpoint;
import org.apache.camel.component.elasticsearch.ElasticsearchOperation;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.client.sniff.SnifferBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchProducer.class);
    protected final ElasticsearchConfiguration configuration;
    private RestClient client;
    private Sniffer sniffer;

    public ElasticsearchProducer(ElasticsearchEndpoint endpoint, ElasticsearchConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.client = endpoint.getClient();
    }

    private ElasticsearchOperation resolveOperation(Exchange exchange) {
        Object request = exchange.getIn().getBody();
        if (request instanceof IndexRequest) {
            return ElasticsearchOperation.Index;
        }
        if (request instanceof GetRequest) {
            return ElasticsearchOperation.GetById;
        }
        if (request instanceof MultiGetRequest) {
            return ElasticsearchOperation.MultiGet;
        }
        if (request instanceof UpdateRequest) {
            return ElasticsearchOperation.Update;
        }
        if (request instanceof BulkRequest) {
            if (this.configuration.getOperation() == ElasticsearchOperation.BulkIndex) {
                return ElasticsearchOperation.BulkIndex;
            }
            return ElasticsearchOperation.Bulk;
        }
        if (request instanceof DeleteRequest) {
            return ElasticsearchOperation.Delete;
        }
        if (request instanceof SearchRequest) {
            return ElasticsearchOperation.Search;
        }
        if (request instanceof DeleteIndexRequest) {
            return ElasticsearchOperation.DeleteIndex;
        }
        ElasticsearchOperation operationConfig = (ElasticsearchOperation)((Object)exchange.getIn().getHeader("operation", ElasticsearchOperation.class));
        if (operationConfig == null) {
            operationConfig = this.configuration.getOperation();
        }
        if (operationConfig == null) {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operationConfig) + "' is not supported");
        }
        return operationConfig;
    }

    public void process(Exchange exchange) throws Exception {
        if (this.configuration.getDisconnect().booleanValue() && this.client == null) {
            this.startClient();
        }
        HighLevelClient restHighLevelClient = new HighLevelClient(this.client);
        Message message = exchange.getIn();
        ElasticsearchOperation operation = this.resolveOperation(exchange);
        boolean configIndexName = false;
        String indexName = (String)message.getHeader("indexName", String.class);
        if (indexName == null) {
            message.setHeader("indexName", (Object)this.configuration.getIndexName());
            configIndexName = true;
        }
        boolean configIndexType = false;
        String indexType = (String)message.getHeader("indexType", String.class);
        if (indexType == null) {
            message.setHeader("indexType", (Object)this.configuration.getIndexType());
            configIndexType = true;
        }
        boolean configWaitForActiveShards = false;
        Integer waitForActiveShards = (Integer)message.getHeader("waitForActiveShards", Integer.class);
        if (waitForActiveShards == null) {
            message.setHeader("waitForActiveShards", (Object)this.configuration.getWaitForActiveShards());
            configWaitForActiveShards = true;
        }
        if (operation == ElasticsearchOperation.Index) {
            IndexRequest indexRequest = (IndexRequest)message.getBody(IndexRequest.class);
            message.setBody((Object)restHighLevelClient.index(indexRequest, new Header[0]).getId());
        } else if (operation == ElasticsearchOperation.Update) {
            UpdateRequest updateRequest = (UpdateRequest)message.getBody(UpdateRequest.class);
            message.setBody((Object)restHighLevelClient.update(updateRequest, new Header[0]).getId());
        } else if (operation == ElasticsearchOperation.GetById) {
            GetRequest getRequest = (GetRequest)message.getBody(GetRequest.class);
            message.setBody((Object)restHighLevelClient.get(getRequest, new Header[0]));
        } else if (operation == ElasticsearchOperation.Bulk) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            message.setBody((Object)restHighLevelClient.bulk(bulkRequest, new Header[0]).getItems());
        } else if (operation == ElasticsearchOperation.BulkIndex) {
            BulkRequest bulkRequest = (BulkRequest)message.getBody(BulkRequest.class);
            message.setBody((Object)restHighLevelClient.bulk(bulkRequest, new Header[0]).getItems());
        } else if (operation == ElasticsearchOperation.Delete) {
            DeleteRequest deleteRequest = (DeleteRequest)message.getBody(DeleteRequest.class);
            message.setBody((Object)restHighLevelClient.delete(deleteRequest, new Header[0]).getResult());
        } else if (operation == ElasticsearchOperation.DeleteIndex) {
            DeleteRequest deleteRequest = (DeleteRequest)message.getBody(DeleteRequest.class);
            message.setBody((Object)this.client.performRequest("Delete", deleteRequest.index(), new Header[0]).getStatusLine().getStatusCode());
        } else if (operation == ElasticsearchOperation.Exists) {
            SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
            sourceBuilder.size(0);
            sourceBuilder.terminateAfter(1);
            SearchRequest searchRequest = new SearchRequest(new String[]{(String)exchange.getIn().getHeader("indexName", String.class)});
            searchRequest.source(sourceBuilder);
            try {
                restHighLevelClient.search(searchRequest, new Header[0]);
                message.setBody((Object)true);
            }
            catch (ElasticsearchStatusException e) {
                if (e.status().equals((Object)RestStatus.NOT_FOUND)) {
                    message.setBody((Object)false);
                }
                throw new IllegalStateException(e);
            }
        } else if (operation == ElasticsearchOperation.Search) {
            SearchRequest searchRequest = (SearchRequest)message.getBody(SearchRequest.class);
            message.setBody((Object)restHighLevelClient.search(searchRequest, new Header[0]).getHits());
        } else if (operation == ElasticsearchOperation.Ping) {
            message.setBody((Object)restHighLevelClient.ping(new Header[0]));
        } else if (operation == ElasticsearchOperation.Info) {
            message.setBody((Object)restHighLevelClient.info(new Header[0]));
        } else {
            throw new IllegalArgumentException("operation value '" + (Object)((Object)operation) + "' is not supported");
        }
        if (configIndexName) {
            message.removeHeader("indexName");
        }
        if (configIndexType) {
            message.removeHeader("indexType");
        }
        if (configWaitForActiveShards) {
            message.removeHeader("waitForActiveShards");
        }
        if (this.configuration.getDisconnect().booleanValue()) {
            IOHelper.close((Closeable)this.client);
            this.client = null;
            if (this.configuration.getEnableSniffer().booleanValue()) {
                IOHelper.close((Closeable)this.sniffer);
                this.sniffer = null;
            }
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!this.configuration.getDisconnect().booleanValue()) {
            this.startClient();
        }
    }

    private void startClient() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, UnknownHostException {
        if (this.client == null) {
            LOG.info("Connecting to the ElasticSearch cluster: " + this.configuration.getClusterName());
            if (this.configuration.getHostAddressesList() != null && !this.configuration.getHostAddressesList().isEmpty()) {
                this.client = this.createClient();
            } else {
                LOG.warn("Incorrect ip address and port parameters settings for ElasticSearch cluster");
            }
        }
    }

    private RestClient createClient() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])this.configuration.getHostAddressesList().toArray(new HttpHost[0]));
        builder.setMaxRetryTimeoutMillis(this.configuration.getMaxRetryTimeout());
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder.setConnectTimeout(this.configuration.getConnectionTimeout()).setSocketTimeout(this.configuration.getSocketTimeout()));
        if (this.configuration.getUser() != null && this.configuration.getPassword() != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.getUser(), this.configuration.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticsearchProducer.lambda$createClient$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        RestClient restClient = builder.build();
        if (this.configuration.getEnableSniffer().booleanValue()) {
            SnifferBuilder snifferBuilder = Sniffer.builder((RestClient)restClient);
            snifferBuilder.setSniffIntervalMillis(this.configuration.getSnifferInterval());
            snifferBuilder.setSniffAfterFailureDelayMillis(this.configuration.getSniffAfterFailureDelay());
            this.sniffer = snifferBuilder.build();
        }
        return restClient;
    }

    protected void doStop() throws Exception {
        if (this.client != null) {
            LOG.info("Disconnecting from ElasticSearch cluster: {}", (Object)this.configuration.getClusterName());
            this.client.close();
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        super.doStop();
    }

    public RestClient getClient() {
        return this.client;
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$createClient$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        return httpClientBuilder;
    }

    private final class HighLevelClient
    extends RestHighLevelClient {
        private HighLevelClient(RestClient restClient) {
            super(restClient, client -> {}, Collections.emptyList());
        }
    }
}

