/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.camel.maven.CamelSpringNamespace;
import org.apache.camel.maven.DocumentationEnricher;
import org.apache.camel.maven.DomFinder;
import org.apache.camel.maven.PackageHelper;
import org.apache.camel.maven.XmlHelper;
import org.apache.camel.util.FileUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Mojo(name="eip-documentation-enricher", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class EipDocumentationEnricherMojo
extends AbstractMojo {
    @Parameter(required=true)
    public File inputCamelSchemaFile;
    @Parameter(required=true)
    public File outputCamelSchemaFile;
    @Parameter(defaultValue="${project.build.directory}/../../../camel-core")
    public File camelCoreDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-core-xml")
    public File camelCoreXmlDir;
    @Parameter(defaultValue="${project.build.directory}/../../../components/camel-spring")
    public File camelSpringDir;
    @Parameter(defaultValue="target/classes/org/apache/camel/model")
    public String pathToModelDir;
    @Parameter(defaultValue="target/classes/org/apache/camel/core/xml")
    public String pathToCoreXmlModelDir;
    @Parameter(defaultValue="target/classes/org/apache/camel/spring")
    public String pathToSpringModelDir;
    @Parameter
    public String deleteFilesAfterRun;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.pathToModelDir == null) {
            throw new MojoExecutionException("pathToModelDir parameter must not be null");
        }
        if (this.inputCamelSchemaFile == null || !this.inputCamelSchemaFile.exists()) {
            this.getLog().info((CharSequence)("Input Camel schema file: " + this.inputCamelSchemaFile + " does not exist. Skip EIP document enrichment"));
            return;
        }
        this.validateExists(this.inputCamelSchemaFile, "inputCamelSchemaFile");
        this.validateIsFile(this.inputCamelSchemaFile, "inputCamelSchemaFile");
        this.validateExists(this.camelCoreDir, "camelCoreDir");
        this.validateExists(this.camelCoreXmlDir, "camelCoreXmlDir");
        this.validateExists(this.camelSpringDir, "camelSpringDir");
        this.validateIsDirectory(this.camelCoreDir, "camelCoreDir");
        this.validateIsDirectory(this.camelCoreXmlDir, "camelCoreXmlDir");
        this.validateIsDirectory(this.camelSpringDir, "camelSpringDir");
        try {
            this.runPlugin();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during plugin execution", e);
        }
        if (this.deleteFilesAfterRun != null) {
            this.deleteFilesAfterDone(this.deleteFilesAfterRun);
        }
    }

    private void runPlugin() throws Exception {
        Document document = XmlHelper.buildNamespaceAwareDocument(this.inputCamelSchemaFile);
        XPath xPath = XmlHelper.buildXPath(new CamelSpringNamespace());
        DomFinder domFinder = new DomFinder(document, xPath);
        DocumentationEnricher documentationEnricher = new DocumentationEnricher(document);
        File rootDir = new File(this.camelCoreDir, this.pathToModelDir);
        Map<String, File> jsonFiles = PackageHelper.findJsonFiles(rootDir);
        File rootDir2 = new File(this.camelCoreXmlDir, this.pathToCoreXmlModelDir);
        Map<String, File> jsonFiles2 = PackageHelper.findJsonFiles(rootDir2);
        File rootDir3 = new File(this.camelSpringDir, this.pathToSpringModelDir);
        Map<String, File> jsonFiles3 = PackageHelper.findJsonFiles(rootDir3);
        jsonFiles.putAll(jsonFiles2);
        jsonFiles.putAll(jsonFiles3);
        NodeList elementsAndTypes = domFinder.findElementsAndTypes();
        documentationEnricher.enrichTopLevelElementsDocumentation(elementsAndTypes, jsonFiles);
        Map<String, String> typeToNameMap = this.buildTypeToNameMap(elementsAndTypes);
        LinkedHashSet<String> injectedTypes = new LinkedHashSet<String>();
        this.getLog().info((CharSequence)("Found " + typeToNameMap.size() + " models to use when enriching the XSD schema"));
        for (Map.Entry<String, String> entry : typeToNameMap.entrySet()) {
            String elementType = entry.getKey();
            String elementName = entry.getValue();
            if (!this.jsonFileExistsForElement(jsonFiles, elementName)) continue;
            this.getLog().debug((CharSequence)("Enriching " + elementName));
            File file = jsonFiles.get(elementName);
            this.injectAttributesDocumentation(domFinder, documentationEnricher, file, elementType, injectedTypes);
        }
        this.saveToFile(document, this.outputCamelSchemaFile, XmlHelper.buildTransformer());
    }

    private boolean jsonFileExistsForElement(Map<String, File> jsonFiles, String elementName) {
        return jsonFiles.containsKey(elementName);
    }

    private void deleteFilesAfterDone(String deleteFiles) {
        String[] names;
        for (String name : names = deleteFiles.split(",")) {
            File file = new File(name);
            FileUtil.deleteFile((File)file);
        }
    }

    private void injectAttributesDocumentation(DomFinder domFinder, DocumentationEnricher documentationEnricher, File jsonFile, String type, Set<String> injectedTypes) throws XPathExpressionException, IOException {
        String baseType;
        if (injectedTypes.contains(type)) {
            return;
        }
        injectedTypes.add(type);
        NodeList attributeElements = domFinder.findAttributesElements(type);
        if (attributeElements.getLength() > 0) {
            documentationEnricher.enrichTypeAttributesDocumentation(this.getLog(), attributeElements, jsonFile);
        }
        if ((baseType = domFinder.findBaseType(type)) != null && !StringUtils.isEmpty((String)baseType)) {
            baseType = this.truncateTypeNamespace(baseType);
            this.injectAttributesDocumentation(domFinder, documentationEnricher, jsonFile, baseType, injectedTypes);
        }
    }

    private Map<String, String> buildTypeToNameMap(NodeList elementsAndTypes) {
        LinkedHashMap<String, String> typeToNameMap = new LinkedHashMap<String, String>();
        for (int i = 0; i < elementsAndTypes.getLength(); ++i) {
            Element item = (Element)elementsAndTypes.item(i);
            String name = item.getAttribute("name");
            String type = item.getAttribute("type");
            if (name == null || type == null) continue;
            type = this.truncateTypeNamespace(type);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Putting attributes type:'%s', name:'%s'", name, type));
            }
            typeToNameMap.put(type, name);
        }
        return typeToNameMap;
    }

    private String truncateTypeNamespace(String baseType) {
        return baseType.replaceAll("tns:", "");
    }

    private void saveToFile(Document document, File outputFile, Transformer transformer) throws FileNotFoundException, TransformerException {
        StreamResult result = new StreamResult(new FileOutputStream(outputFile));
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
    }

    private void validateIsFile(File file, String name) throws MojoExecutionException {
        if (!file.isFile()) {
            throw new MojoExecutionException(name + "is not a file");
        }
    }

    private void validateIsDirectory(File file, String name) throws MojoExecutionException {
        if (!file.isDirectory()) {
            throw new MojoExecutionException(name + "is not a directory");
        }
    }

    private void validateExists(File file, String name) throws MojoExecutionException {
        if (file == null || !file.exists()) {
            throw new MojoExecutionException(name + " does not exist");
        }
    }
}

