/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.PackageHelper;
import org.apache.camel.maven.XmlHelper;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.maven.plugin.logging.Log;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentationEnricher {
    private final Document document;

    public DocumentationEnricher(Document document) {
        this.document = document;
    }

    public void enrichTopLevelElementsDocumentation(NodeList elements, Map<String, File> jsonFiles) throws IOException {
        for (int i = 0; i < elements.getLength(); ++i) {
            Element item = (Element)elements.item(i);
            String name = item.getAttribute("name");
            if (!jsonFiles.containsKey(name)) continue;
            this.addElementDocumentation(item, jsonFiles.get(name));
        }
    }

    public void enrichTypeAttributesDocumentation(Log log, NodeList attributeElements, File jsonFile) throws IOException {
        for (int j = 0; j < attributeElements.getLength(); ++j) {
            Element item = (Element)attributeElements.item(j);
            this.addAttributeDocumentation(log, item, jsonFile);
        }
    }

    private void addElementDocumentation(Element item, File jsonFile) throws IOException {
        List rows = JsonSchemaHelper.parseJsonSchema((String)"model", (String)PackageHelper.fileToString(jsonFile), (boolean)false);
        for (Map row : rows) {
            if (!row.containsKey("description")) continue;
            String descriptionText = (String)row.get("description");
            this.addDocumentation(item, descriptionText);
            break;
        }
    }

    private void addAttributeDocumentation(Log log, Element item, File jsonFile) throws IOException {
        String name = item.getAttribute("name");
        if (XmlHelper.isNullOrEmpty(name)) {
            return;
        }
        String descriptionText = null;
        String defaultValueText = null;
        String deprecatedText = null;
        List rows = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)PackageHelper.fileToString(jsonFile), (boolean)true);
        for (Map row : rows) {
            if (!name.equals(row.get("name"))) continue;
            descriptionText = (String)row.get("description");
            defaultValueText = (String)row.get("defaultValue");
            deprecatedText = (String)row.get("deprecated");
        }
        if ("useBlueprintPropertyResolver".equals(name)) {
            descriptionText = "Whether to automatic detect OSGi Blueprint property placeholder service in use, and bridge with Camel property placeholder. When enabled this allows you to only setup OSGi Blueprint property placeholder and Camel can use the properties in the <camelContext>.";
            defaultValueText = "true";
        }
        if ("true".equals(deprecatedText)) {
            descriptionText = "Deprecated: " + descriptionText;
        }
        if (!XmlHelper.isNullOrEmpty(descriptionText)) {
            String text = descriptionText;
            if (!XmlHelper.isNullOrEmpty(defaultValueText)) {
                text = text + (!text.endsWith(".") ? "." : "") + " Default value: " + defaultValueText;
            }
            this.addDocumentation(item, text);
        } else {
            boolean skip;
            boolean bl = skip = "customId".equals(name) || "inheritErrorHandler".equals(name) || "rest".equals(name) && jsonFile.getName().endsWith("route.json");
            if (!skip) {
                log.warn((CharSequence)("Cannot find documentation for name: " + name + " in json schema: " + jsonFile));
            }
        }
    }

    private void addDocumentation(Element item, String textContent) {
        Element annotation = this.document.createElement("xs:annotation");
        Element documentation = this.document.createElement("xs:documentation");
        documentation.setAttribute("xml:lang", "en");
        CDATASection cdataDocumentationText = this.document.createCDATASection(this.formatTextContent(item, textContent));
        documentation.appendChild(cdataDocumentationText);
        annotation.appendChild(documentation);
        if (item.getFirstChild() != null) {
            item.insertBefore(annotation, item.getFirstChild());
        } else {
            item.appendChild(annotation);
        }
    }

    private String formatTextContent(Element item, String textContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.lineSeparator()).append(WordUtils.wrap((String)textContent, (int)80)).append(System.lineSeparator()).append(StringUtils.repeat((String)"  ", (int)this.getNodeDepth(item)));
        return stringBuilder.toString();
    }

    private int getNodeDepth(Node item) {
        int depth = 1;
        while (item.getParentNode() != null) {
            ++depth;
            item = item.getParentNode();
        }
        return depth;
    }
}

