/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.camel.maven.CamelSpringNamespace;
import org.apache.camel.maven.DocumentationEnricher;
import org.apache.camel.maven.DomFinder;
import org.apache.camel.maven.PackageHelper;
import org.apache.camel.maven.XmlHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Mojo(name="eip-documentation-enricher", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresProject=true, defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class EipDocumentationEnricherMojo
extends AbstractMojo {
    @Parameter(required=true)
    public File inputCamelSchemaFile;
    @Parameter(required=true)
    public File outputCamelSchemaFile;
    @Parameter(defaultValue="${project.build.directory}/../../..//camel-core")
    public File camelCoreDir;
    @Parameter(defaultValue="target/classes/org/apache/camel/model")
    public String pathToModelDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.pathToModelDir == null) {
            throw new MojoExecutionException("pathToModelDir parameter must not be null");
        }
        this.validateExists(this.inputCamelSchemaFile, "inputCamelSchemaFile");
        this.validateIsFile(this.inputCamelSchemaFile, "inputCamelSchemaFile");
        this.validateExists(this.camelCoreDir, "camelCoreDir");
        this.validateIsDirectory(this.camelCoreDir, "camelCoreDir");
        try {
            this.runPlugin();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error during plugin execution", e);
        }
    }

    private void runPlugin() throws Exception {
        File rootDir = new File(this.camelCoreDir, this.pathToModelDir);
        Document document = XmlHelper.buildNamespaceAwareDocument(this.inputCamelSchemaFile);
        XPath xPath = XmlHelper.buildXPath(new CamelSpringNamespace());
        DomFinder domFinder = new DomFinder(document, xPath);
        DocumentationEnricher documentationEnricher = new DocumentationEnricher(document);
        Map<String, File> jsonFiles = PackageHelper.findJsonFiles(rootDir);
        NodeList elementsAndTypes = domFinder.findElementsAndTypes();
        documentationEnricher.enrichTopLevelElementsDocumentation(elementsAndTypes, jsonFiles);
        Map<String, String> typeToNameMap = this.buildTypeToNameMap(elementsAndTypes);
        HashSet<String> injectedTypes = new HashSet<String>();
        for (Map.Entry<String, String> entry : typeToNameMap.entrySet()) {
            String elementType = entry.getKey();
            String elementName = entry.getValue();
            if (!this.jsonFileExistsForElement(jsonFiles, elementName)) continue;
            this.injectAttributesDocumentation(domFinder, documentationEnricher, jsonFiles.get(elementName), elementType, injectedTypes);
        }
        this.saveToFile(document, this.outputCamelSchemaFile, XmlHelper.buildTransformer());
    }

    private boolean jsonFileExistsForElement(Map<String, File> jsonFiles, String elementName) {
        return jsonFiles.containsKey(elementName);
    }

    private void injectAttributesDocumentation(DomFinder domFinder, DocumentationEnricher documentationEnricher, File jsonFile, String type, Set<String> injectedTypes) throws XPathExpressionException, IOException {
        String baseType;
        if (injectedTypes.contains(type)) {
            return;
        }
        injectedTypes.add(type);
        NodeList attributeElements = domFinder.findAttributesElements(type);
        if (attributeElements.getLength() > 0) {
            documentationEnricher.enrichTypeAttributesDocumentation(attributeElements, jsonFile);
        }
        if ((baseType = domFinder.findBaseType(type)) != null && !StringUtils.isEmpty((String)baseType)) {
            baseType = this.truncateTypeNamespace(baseType);
            this.injectAttributesDocumentation(domFinder, documentationEnricher, jsonFile, baseType, injectedTypes);
        }
    }

    private Map<String, String> buildTypeToNameMap(NodeList elementsAndTypes) {
        HashMap<String, String> typeToNameMap = new HashMap<String, String>();
        for (int i = 0; i < elementsAndTypes.getLength(); ++i) {
            Element item = (Element)elementsAndTypes.item(i);
            String name = item.getAttribute("name");
            String type = item.getAttribute("type");
            if (name == null || type == null) continue;
            type = this.truncateTypeNamespace(type);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)String.format("Putting attributes type:'%s', name:'%s'", name, type));
            }
            typeToNameMap.put(type, name);
        }
        return typeToNameMap;
    }

    private String truncateTypeNamespace(String baseType) {
        return baseType.replaceAll("tns:", "");
    }

    private void saveToFile(Document document, File outputFile, Transformer transformer) throws FileNotFoundException, TransformerException {
        StreamResult result = new StreamResult(new FileOutputStream(outputFile));
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
    }

    private void validateIsFile(File file, String name) throws MojoExecutionException {
        if (!file.isFile()) {
            throw new MojoExecutionException(name + "is not a file");
        }
    }

    private void validateIsDirectory(File file, String name) throws MojoExecutionException {
        if (!file.isDirectory()) {
            throw new MojoExecutionException(name + "is not a directory");
        }
    }

    private void validateExists(File file, String name) throws MojoExecutionException {
        if (file == null || !file.exists()) {
            throw new MojoExecutionException(name + " does not exist");
        }
    }
}

