/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.camel.maven.PackageHelper;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentationEnricher {
    private final Document document;

    public DocumentationEnricher(Document document) {
        this.document = document;
    }

    public void enrichTopLevelElementsDocumentation(NodeList elements, Map<String, File> jsonFiles) throws IOException {
        for (int i = 0; i < elements.getLength(); ++i) {
            Element item = (Element)elements.item(i);
            String name = item.getAttribute("name");
            if (!jsonFiles.containsKey(name)) continue;
            this.addElementDocumentation(item, jsonFiles.get(name));
        }
    }

    public void enrichTypeAttributesDocumentation(NodeList attributeElements, File jsonFile) throws IOException {
        for (int j = 0; j < attributeElements.getLength(); ++j) {
            Element item = (Element)attributeElements.item(j);
            this.addAttributeDocumentation(item, jsonFile);
        }
    }

    private void addElementDocumentation(Element item, File jsonFile) throws IOException {
        List rows = JsonSchemaHelper.parseJsonSchema((String)"model", (String)PackageHelper.fileToString(jsonFile), (boolean)false);
        for (Map row : rows) {
            if (!row.containsKey("description")) continue;
            String descriptionText = (String)row.get("description");
            this.addDocumentation(item, descriptionText);
            break;
        }
    }

    private void addAttributeDocumentation(Element item, File jsonFile) throws IOException {
        List rows = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)PackageHelper.fileToString(jsonFile), (boolean)true);
        for (Map row : rows) {
            String descriptionText;
            if (!item.getAttribute("name").equals(row.get("name")) || (descriptionText = (String)row.get("description")) == null) continue;
            this.addDocumentation(item, descriptionText);
            break;
        }
    }

    private void addDocumentation(Element item, String textContent) {
        Element annotation = this.document.createElement("xs:annotation");
        Element documentation = this.document.createElement("xs:documentation");
        documentation.setAttribute("xml:lang", "en");
        CDATASection cdataDocumentationText = this.document.createCDATASection(this.formatTextContent(item, textContent));
        documentation.appendChild(cdataDocumentationText);
        annotation.appendChild(documentation);
        if (item.getFirstChild() != null) {
            item.insertBefore(annotation, item.getFirstChild());
        } else {
            item.appendChild(annotation);
        }
    }

    private String formatTextContent(Element item, String textContent) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(System.lineSeparator()).append(WordUtils.wrap((String)textContent, (int)80)).append(System.lineSeparator()).append(StringUtils.repeat((String)"  ", (int)this.getNodeDepth(item)));
        return stringBuilder.toString();
    }

    private int getNodeDepth(Node item) {
        int depth = 1;
        while (item.getParentNode() != null) {
            ++depth;
            item = item.getParentNode();
        }
        return depth;
    }
}

