/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.component.dropbox.util.DropboxException;

public final class DropboxPropertyManager {
    private static final Lock LOCK = new ReentrantLock();
    private static Properties properties;
    private static DropboxPropertyManager instance;

    private DropboxPropertyManager() {
    }

    public static DropboxPropertyManager getInstance() throws Exception {
        LOCK.lock();
        try {
            if (instance == null) {
                instance = new DropboxPropertyManager();
                properties = DropboxPropertyManager.loadProperties();
            }
            DropboxPropertyManager dropboxPropertyManager = instance;
            return dropboxPropertyManager;
        }
        finally {
            LOCK.unlock();
        }
    }

    public String getProperty(String key) {
        return properties.getProperty(key);
    }

    private static Properties loadProperties() throws DropboxException {
        URL url = DropboxPropertyManager.class.getResource("/dropbox.properties");
        if (url == null) {
            throw new DropboxException("dropbox.properties could not be found");
        }
        Properties properties = new Properties();
        try (InputStream inStream = url.openStream();){
            properties.load(inStream);
        }
        catch (IOException e) {
            throw new DropboxException("dropbox.properties can't be read", e);
        }
        return properties;
    }
}

