/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.SearchMatchV2;
import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxSearchResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxConstants;
import org.apache.camel.component.dropbox.util.DropboxHelper;
import org.apache.camel.component.dropbox.validator.DropboxConfigurationValidator;

public class DropboxSearchProducer
extends DropboxProducer {
    public DropboxSearchProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        String remotePath = DropboxHelper.getRemotePath(this.configuration, exchange);
        String query = DropboxHelper.getQuery(this.configuration, exchange);
        DropboxConfigurationValidator.validateSearchOp(remotePath);
        DropboxSearchResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).search(remotePath, query);
        StringBuilder fileExtracted = new StringBuilder();
        for (SearchMatchV2 entry : result.getFound()) {
            Metadata metadataValue = entry.getMetadata().getMetadataValue();
            fileExtracted.append(metadataValue.getName()).append('-').append(metadataValue.getPathDisplay()).append('\n');
        }
        exchange.getIn().setHeader(DropboxConstants.FOUND_FILES, (Object)fileExtracted.toString());
        exchange.getIn().setBody(result.getFound());
    }
}

