/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.util.DropboxOperation;
import org.apache.camel.component.dropbox.util.DropboxPropertyManager;
import org.apache.camel.component.dropbox.util.DropboxUploadMode;
import org.apache.camel.component.dropbox.validator.DropboxConfigurationValidator;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="dropbox")
public class DropboxComponent
extends DefaultComponent {
    public DropboxComponent() {
        this(null);
    }

    public DropboxComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DropboxConfiguration configuration = new DropboxConfiguration();
        configuration.setAccessToken((String)parameters.get("accessToken"));
        if (parameters.get("expireIn") != null) {
            configuration.setExpireIn(Long.valueOf((String)parameters.get("expireIn")));
        }
        configuration.setRefreshToken((String)parameters.get("refreshToken"));
        configuration.setApiKey((String)parameters.get("apiKey"));
        configuration.setApiSecret((String)parameters.get("apiSecret"));
        configuration.setLocalPath((String)parameters.get("localPath"));
        configuration.setRemotePath(parameters.get("remotePath") != null ? ((String)parameters.get("remotePath")).replaceAll("\\s", "+") : null);
        configuration.setNewRemotePath((String)parameters.get("newRemotePath"));
        configuration.setQuery((String)parameters.get("query"));
        configuration.setOperation(DropboxOperation.valueOf(remaining));
        configuration.setClientIdentifier(parameters.get("clientIdentifier") == null ? DropboxPropertyManager.getInstance().getProperty("clientIdentifier") : (String)parameters.get("clientIdentifier"));
        if (parameters.get("uploadMode") != null) {
            configuration.setUploadMode(DropboxUploadMode.valueOf((String)parameters.get("uploadMode")));
        }
        DropboxEndpoint endpoint = new DropboxEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        DropboxConfigurationValidator.validateCommonProperties(configuration);
        return endpoint;
    }
}

