/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.nlp;

import ai.djl.Model;
import ai.djl.inference.Predictor;
import ai.djl.modality.nlp.qa.QAInput;
import ai.djl.translate.TranslateException;
import ai.djl.translate.Translator;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.DJLEndpoint;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class CustomQuestionAnswerPredictor
extends AbstractPredictor {
    private final String modelName;
    private final String translatorName;

    public CustomQuestionAnswerPredictor(DJLEndpoint endpoint) {
        super(endpoint);
        this.modelName = endpoint.getModel();
        this.translatorName = endpoint.getTranslator();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String result;
        Object body = exchange.getIn().getBody();
        if (body instanceof QAInput) {
            QAInput input = (QAInput)exchange.getIn().getBody(QAInput.class);
            result = this.predict(exchange, input);
        } else if (body instanceof String[]) {
            String[] strs = (String[])exchange.getIn().getBody(String[].class);
            if (strs.length < 2) {
                throw new RuntimeCamelException("Input String[] should have two elements");
            }
            QAInput input = new QAInput(strs[0], strs[1]);
            result = this.predict(exchange, input);
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be String[] or QAInput");
        }
        exchange.getIn().setBody((Object)result);
    }

    protected String predict(Exchange exchange, QAInput input) {
        String string;
        block8: {
            Model model = (Model)exchange.getContext().getRegistry().lookupByNameAndType(this.modelName, Model.class);
            Translator translator = (Translator)exchange.getContext().getRegistry().lookupByNameAndType(this.translatorName, Translator.class);
            exchange.getIn().setHeader("CamelDjlInput", (Object)input);
            Predictor predictor = model.newPredictor(translator);
            try {
                string = (String)predictor.predict((Object)input);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return string;
    }
}

