/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean;

import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.digitalocean.DigitalOceanComponent;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.producer.DigitalOceanAccountProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanActionsProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanBlockStoragesProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanDropletsProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanFloatingIPsProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanImagesProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanKeysProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanRegionsProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanSizesProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanSnapshotsProducer;
import org.apache.camel.component.digitalocean.producer.DigitalOceanTagsProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="digitalocean", title="DigitalOcean", syntax="digitalocean:operation", producerOnly=true, category={Category.CLOUD, Category.MANAGEMENT})
public class DigitalOceanEndpoint
extends DefaultEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(DigitalOceanEndpoint.class);
    @UriParam
    private DigitalOceanConfiguration configuration;
    private DigitalOceanClient digitalOceanClient;

    public DigitalOceanEndpoint(String uri, DigitalOceanComponent component, DigitalOceanConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public Producer createProducer() throws Exception {
        LOG.trace("Resolve producer digitalocean endpoint {{}}", (Object)this.configuration.getResource());
        switch (this.configuration.getResource()) {
            case account: {
                return new DigitalOceanAccountProducer(this, this.configuration);
            }
            case actions: {
                return new DigitalOceanActionsProducer(this, this.configuration);
            }
            case blockStorages: {
                return new DigitalOceanBlockStoragesProducer(this, this.configuration);
            }
            case droplets: {
                return new DigitalOceanDropletsProducer(this, this.configuration);
            }
            case images: {
                return new DigitalOceanImagesProducer(this, this.configuration);
            }
            case snapshots: {
                return new DigitalOceanSnapshotsProducer(this, this.configuration);
            }
            case keys: {
                return new DigitalOceanKeysProducer(this, this.configuration);
            }
            case regions: {
                return new DigitalOceanRegionsProducer(this, this.configuration);
            }
            case sizes: {
                return new DigitalOceanSizesProducer(this, this.configuration);
            }
            case floatingIPs: {
                return new DigitalOceanFloatingIPsProducer(this, this.configuration);
            }
            case tags: {
                return new DigitalOceanTagsProducer(this, this.configuration);
            }
        }
        throw new UnsupportedOperationException("Operation specified is not valid for producer");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public void doStart() throws Exception {
        super.doStart();
        if (this.configuration.getDigitalOceanClient() != null) {
            this.digitalOceanClient = this.configuration.getDigitalOceanClient();
        } else if (this.configuration.getHttpProxyHost() != null && this.configuration.getHttpProxyPort() != null) {
            HttpClientBuilder builder = HttpClients.custom().useSystemProperties().setProxy(new HttpHost(this.configuration.getHttpProxyHost(), this.configuration.getHttpProxyPort().intValue()));
            if (this.configuration.getHttpProxyUser() != null && this.configuration.getHttpProxyPassword() != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.configuration.getHttpProxyHost(), this.configuration.getHttpProxyPort().intValue()), (Credentials)new UsernamePasswordCredentials(this.configuration.getHttpProxyUser(), this.configuration.getHttpProxyPassword()));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            this.digitalOceanClient = new DigitalOceanClient("v2", this.configuration.getOAuthToken(), builder.build());
        } else {
            this.digitalOceanClient = new DigitalOceanClient(this.configuration.getOAuthToken());
        }
    }

    public DigitalOceanConfiguration getConfiguration() {
        return this.configuration;
    }

    public DigitalOceanClient getDigitalOceanClient() {
        return this.digitalOceanClient;
    }
}

