/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanActionsProducer
extends DigitalOceanProducer {
    public DigitalOceanActionsProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getActions(exchange);
                break;
            }
            case get: {
                this.getAction(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getAction(Exchange exchange) throws Exception {
        Integer actionId = (Integer)exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        if (ObjectHelper.isEmpty((Object)actionId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().getActionInfo(actionId);
        LOG.trace("Action [{}] ", (Object)action);
        exchange.getOut().setBody((Object)action);
    }

    private void getActions(Exchange exchange) throws Exception {
        Actions actions = this.getEndpoint().getDigitalOceanClient().getAvailableActions(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Actions : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), actions.getActions()});
        exchange.getOut().setBody((Object)actions.getActions());
    }
}

