/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.DigitalOceanException;
import org.apache.camel.component.digitalocean.constants.DigitalOceanResources;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalOceanComponent
extends UriEndpointComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(DigitalOceanComponent.class);

    public DigitalOceanComponent() {
        super(DigitalOceanEndpoint.class);
    }

    public DigitalOceanComponent(CamelContext context) {
        super(context, DigitalOceanEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DigitalOceanConfiguration configuration = new DigitalOceanConfiguration();
        this.setProperties(configuration, parameters);
        configuration.setResource(DigitalOceanResources.valueOf(remaining));
        if (ObjectHelper.isEmpty((Object)configuration.getOAuthToken()) && ObjectHelper.isEmpty((Object)configuration.getDigitalOceanClient())) {
            throw new DigitalOceanException("oAuthToken or digitalOceanClient must be specified");
        }
        return new DigitalOceanEndpoint(uri, this, configuration);
    }
}

