/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dfdl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.component.dfdl.DfdlComponent;
import org.apache.camel.component.dfdl.DfdlParseException;
import org.apache.camel.component.dfdl.DfdlUnparseException;
import org.apache.camel.component.dfdl.ParseDirection;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResourceHelper;
import org.apache.daffodil.japi.Daffodil;
import org.apache.daffodil.japi.DataProcessor;
import org.apache.daffodil.japi.Diagnostic;
import org.apache.daffodil.japi.ParseResult;
import org.apache.daffodil.japi.ProcessorFactory;
import org.apache.daffodil.japi.UnparseResult;
import org.apache.daffodil.japi.infoset.InfosetInputter;
import org.apache.daffodil.japi.infoset.InfosetOutputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetInputter;
import org.apache.daffodil.japi.infoset.W3CDOMInfosetOutputter;
import org.apache.daffodil.japi.io.InputSourceDataInputStream;
import org.w3c.dom.Document;

@UriEndpoint(firstVersion="4.11.0", scheme="dfdl", title="DFDL", syntax="dfdl:schemaUri", producerOnly=true, category={Category.TRANSFORMATION})
public class DfdlEndpoint
extends ProcessorEndpoint {
    @UriPath
    @Metadata(required=true, description="The path to the DFDL schema file.")
    private String schemaUri;
    @UriParam
    @Metadata(defaultValue="PARSE", description="Transform direction. Either PARSE or UNPARSE")
    private ParseDirection parseDirection;
    @UriParam(description="The root element name of the schema to use. If not specified, the first root element in the schema will be used.", label="advanced", defaultValue="")
    private String rootElement = "";
    @UriParam(description="The root namespace of the schema to use.", label="advanced", defaultValue="")
    private String rootNamespace = "";
    private DataProcessor daffodilProcessor;

    public DfdlEndpoint(String uri, DfdlComponent component, String schemaFile) {
        super(uri, (Component)component);
        this.schemaUri = schemaFile;
    }

    public void doInit() throws Exception {
        super.doInit();
        Resource schemaResource = ResourceHelper.resolveMandatoryResource((CamelContext)this.getCamelContext(), (String)this.getSchemaUri());
        ProcessorFactory processorFactory = this.getRootElement() != null && !this.getRootElement().isEmpty() && this.getRootNamespace() != null && !this.getRootNamespace().isEmpty() ? Daffodil.compiler().compileSource(schemaResource.getURI(), this.getRootElement(), this.getRootNamespace()) : Daffodil.compiler().compileSource(schemaResource.getURI());
        if (processorFactory.isError()) {
            StringBuilder buf = new StringBuilder("Failed to initialize dfdl endpoint: [");
            for (Diagnostic d : processorFactory.getDiagnostics()) {
                buf.append(d.getMessage()).append("; ");
            }
            buf.append("]");
            throw new IOException(buf.toString());
        }
        this.daffodilProcessor = processorFactory.onPath("/");
    }

    protected void onExchange(Exchange exchange) throws Exception {
        if (this.getParseDirection() == ParseDirection.UNPARSE) {
            ByteArrayOutputStream bos;
            Document xmlDocument = (Document)exchange.getIn().getBody(Document.class);
            W3CDOMInfosetInputter inputter = new W3CDOMInfosetInputter(xmlDocument);
            UnparseResult result = this.daffodilProcessor.unparse((InfosetInputter)inputter, Channels.newChannel(bos = new ByteArrayOutputStream()));
            if (result.isError()) {
                exchange.setException((Throwable)new DfdlUnparseException(result));
                return;
            }
            exchange.getMessage().setBody((Object)bos);
        } else {
            W3CDOMInfosetOutputter outputter;
            byte[] binary = (byte[])exchange.getIn().getBody(byte[].class);
            InputSourceDataInputStream inputStream = new InputSourceDataInputStream(binary);
            ParseResult result = this.daffodilProcessor.parse(inputStream, (InfosetOutputter)(outputter = new W3CDOMInfosetOutputter()));
            if (result.isError()) {
                exchange.setException((Throwable)new DfdlParseException(result));
                return;
            }
            exchange.getMessage().setBody((Object)outputter.getResult());
        }
    }

    public ParseDirection getParseDirection() {
        return this.parseDirection;
    }

    public void setParseDirection(ParseDirection direction) {
        this.parseDirection = direction;
    }

    public String getSchemaUri() {
        return this.schemaUri;
    }

    public void setSchemaUri(String schemaUri) {
        this.schemaUri = schemaUri;
    }

    public String getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(String rootElement) {
        this.rootElement = rootElement;
    }

    public String getRootNamespace() {
        return this.rootNamespace;
    }

    public void setRootNamespace(String rootNamespace) {
        this.rootNamespace = rootNamespace;
    }
}

