/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debug;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.debugger.DebuggerJmxConnectorService;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DebuggerFactory;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.LifecycleStrategySupport;

@JdkService(value="debugger-factory")
public class CamelDebuggerFactory
implements DebuggerFactory {
    public Debugger createDebugger(CamelContext camelContext) throws Exception {
        if (camelContext.hasService(BacklogDebugger.class) == null) {
            final BacklogDebugger backlog = DefaultBacklogDebugger.createDebugger((CamelContext)camelContext);
            backlog.setStandby(camelContext.isDebugStandby());
            camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
            camelContext.setMessageHistory(Boolean.valueOf(true));
            camelContext.setDebugging(Boolean.valueOf(true));
            DebuggerJmxConnectorService connector = new DebuggerJmxConnectorService();
            connector.setCreateConnector(true);
            camelContext.addService((Object)connector);
            camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

                public void onContextStarted(CamelContext context) {
                    if (!backlog.isStandby()) {
                        backlog.enableDebugger();
                    }
                }

                public void onContextStopping(CamelContext context) {
                    backlog.disableDebugger();
                }
            });
            camelContext.addService((Object)backlog, true, true);
        }
        return null;
    }

    public String toString() {
        return "camel-debug";
    }
}

