/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dapr.operations;

import io.dapr.client.DaprClient;
import io.dapr.client.domain.GetConfigurationRequest;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.component.dapr.DaprConfigurationOptionsProxy;
import org.apache.camel.component.dapr.operations.DaprOperationHandler;
import org.apache.camel.component.dapr.operations.DaprOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class DaprConfigurationHandler
implements DaprOperationHandler {
    private final DaprConfigurationOptionsProxy configurationOptionsProxy;

    public DaprConfigurationHandler(DaprConfigurationOptionsProxy configurationOptionsProxy) {
        this.configurationOptionsProxy = configurationOptionsProxy;
    }

    @Override
    public DaprOperationResponse handle(Exchange exchange, DaprClient client) {
        String configStore = this.configurationOptionsProxy.getConfigStore(exchange);
        List<String> configKeys = this.configurationOptionsProxy.getConfigKeys(exchange);
        Map<String, String> metadata = this.configurationOptionsProxy.getMetadata(exchange);
        GetConfigurationRequest configRequest = new GetConfigurationRequest(configStore, configKeys);
        configRequest.setMetadata(metadata);
        Map response = (Map)client.getConfiguration(configRequest).block();
        return DaprOperationResponse.createFromConfig(response);
    }

    @Override
    public void validateConfiguration(Exchange exchange) {
        String configStore = this.configurationOptionsProxy.getConfigStore(exchange);
        List<String> configKeys = this.configurationOptionsProxy.getConfigKeys(exchange);
        if (ObjectHelper.isEmpty((String)configStore) || ObjectHelper.isEmpty(configKeys)) {
            throw new IllegalArgumentException("configStore and configKeys are mandatory for get configuration operation");
        }
    }
}

