/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.transport;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Producer;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.cxf.transport.CamelOutputStream;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelConduit
extends AbstractConduit
implements Configurable {
    protected static final String BASE_BEAN_NAME_SUFFIX = ".camel-conduit";
    private static final Logger LOG = LoggerFactory.getLogger(CamelConduit.class);
    private static final java.util.logging.Logger JUL_LOG = LogUtils.getL7dLogger(CamelConduit.class);
    private CamelContext camelContext;
    private final EndpointInfo endpointInfo;
    private String targetCamelEndpointUri;
    private final Producer producer;
    private ProducerTemplate camelTemplate;
    private final Bus bus;
    private final HeaderFilterStrategy headerFilterStrategy;

    public CamelConduit(CamelContext context, Bus b, EndpointInfo endpointInfo) {
        this(context, b, endpointInfo, null);
    }

    public CamelConduit(CamelContext context, Bus b, EndpointInfo epInfo, EndpointReferenceType targetReference) {
        this(context, b, epInfo, targetReference, null);
    }

    public CamelConduit(CamelContext context, Bus b, EndpointInfo epInfo, EndpointReferenceType targetReference, HeaderFilterStrategy headerFilterStrategy) {
        super(CamelConduit.getTargetReference((EndpointInfo)epInfo, (EndpointReferenceType)targetReference, (Bus)b));
        String address = epInfo.getAddress();
        if (address != null) {
            this.targetCamelEndpointUri = address.substring("camel:".length());
            if (this.targetCamelEndpointUri.startsWith("//")) {
                this.targetCamelEndpointUri = this.targetCamelEndpointUri.substring(2);
            }
        }
        this.camelContext = context;
        this.endpointInfo = epInfo;
        this.bus = b;
        this.initConfig();
        this.headerFilterStrategy = headerFilterStrategy;
        Endpoint target = this.getCamelContext().getEndpoint(this.targetCamelEndpointUri);
        try {
            this.producer = target.createProducer();
            this.producer.start();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot create the producer rightly", (Throwable)e);
        }
    }

    public void setCamelContext(CamelContext context) {
        this.camelContext = context;
    }

    public CamelContext getCamelContext() {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        return this.camelContext;
    }

    public void prepare(Message message) throws IOException {
        LOG.trace("CamelConduit send message");
        CamelOutputStream os = new CamelOutputStream(this.targetCamelEndpointUri, this.producer, this.headerFilterStrategy, this.getMessageObserver(), message);
        message.setContent(OutputStream.class, (Object)os);
    }

    public void close() {
        LOG.trace("CamelConduit closed ");
        try {
            this.producer.stop();
        }
        catch (Exception e) {
            LOG.warn("CamelConduit producer stop with the exception", (Throwable)e);
        }
    }

    protected java.util.logging.Logger getLogger() {
        return JUL_LOG;
    }

    public String getBeanName() {
        if (this.endpointInfo == null || this.endpointInfo.getName() == null) {
            return "default.camel-conduit";
        }
        return this.endpointInfo.getName().toString() + BASE_BEAN_NAME_SUFFIX;
    }

    private void initConfig() {
        Configurer configurer;
        if (this.bus != null && null != (configurer = (Configurer)this.bus.getExtension(Configurer.class))) {
            configurer.configureBean((Object)this);
        }
    }

    @Deprecated
    public ProducerTemplate getCamelTemplate() {
        if (this.camelTemplate == null) {
            this.camelTemplate = this.getCamelContext().createProducerTemplate();
        }
        return this.camelTemplate;
    }

    @Deprecated
    public void setCamelTemplate(ProducerTemplate template) {
        this.camelTemplate = template;
    }
}

