/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.csimple.CSimpleCodeGenerator;
import org.apache.camel.language.csimple.CSimpleGeneratedCode;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelCSimpleExpressionDetails;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.tooling.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;

@Mojo(name="generate", threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class GenerateMojo
extends AbstractExecMojo {
    public static final String GENERATED_MSG = "Generated by camel build tools - do NOT edit this file!";
    public static final String RESOURCE_FILE = "META-INF/services/org/apache/camel/csimple.properties";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/generated/java")
    protected File outputDir;
    @Parameter(defaultValue="${project.basedir}/src/generated/resources")
    protected File outputResourceDir;
    @Parameter(defaultValue="${project.basedir}/src/main/resources")
    protected File resourceDir;
    @Parameter(property="camel.includeJava", defaultValue="true")
    private boolean includeJava;
    @Parameter(property="camel.includeXml", defaultValue="true")
    private boolean includeXml;
    @Parameter(property="camel.includeTest", defaultValue="false")
    private boolean includeTest;
    @Parameter(property="camel.includes")
    private String includes;
    @Parameter(property="camel.excludes")
    private String excludes;
    private final Set<String> imports = new TreeSet<String>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.loadConfiguration();
        CSimpleCodeGenerator generator = new CSimpleCodeGenerator();
        generator.setAliases(this.aliases);
        generator.setImports(this.imports);
        this.doExecuteRoutes(generator);
    }

    protected void doExecuteRoutes(CSimpleCodeGenerator generator) {
        String baseDir;
        String fqn;
        String dir;
        Object obj;
        Object list;
        ArrayList csimpleExpressions = new ArrayList();
        LinkedHashSet<File> javaFiles = new LinkedHashSet<File>();
        LinkedHashSet<File> xmlFiles = new LinkedHashSet<File>();
        if (this.includeJava) {
            list = this.project.getCompileSourceRoots();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                obj = iterator.next();
                dir = (String)obj;
                this.findJavaFiles(new File(dir), javaFiles);
            }
            if (this.includeTest) {
                list = this.project.getTestCompileSourceRoots();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    obj = iterator2.next();
                    dir = (String)obj;
                    this.findJavaFiles(new File(dir), javaFiles);
                }
            }
        }
        if (this.includeXml) {
            list = this.project.getResources();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                obj = iterator.next();
                dir = (Resource)obj;
                this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
            }
            if (this.includeTest) {
                list = this.project.getTestResources();
                Iterator iterator3 = list.iterator();
                while (iterator3.hasNext()) {
                    obj = iterator3.next();
                    dir = (Resource)obj;
                    this.findXmlFiles(new File(dir.getDirectory()), xmlFiles);
                }
            }
        }
        for (File file : javaFiles) {
            if (!this.matchRouteFile(file)) continue;
            try {
                ArrayList fileCSimpleExpressions = new ArrayList();
                fqn = file.getPath();
                baseDir = ".";
                JavaType out = Roaster.parse((File)file);
                if (!(out instanceof JavaClassSource)) continue;
                JavaClassSource clazz = (JavaClassSource)out;
                RouteBuilderParser.parseRouteBuilderCSimpleExpressions((JavaClassSource)clazz, (String)baseDir, (String)fqn, fileCSimpleExpressions);
                csimpleExpressions.addAll(fileCSimpleExpressions);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing java file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        for (File file : xmlFiles) {
            if (!this.matchRouteFile(file)) continue;
            try {
                ArrayList fileSimpleExpressions = new ArrayList();
                fqn = file.getPath();
                baseDir = ".";
                FileInputStream is = new FileInputStream(file);
                XmlRouteParser.parseXmlRouteCSimpleExpressions((InputStream)is, (String)baseDir, (String)fqn, fileSimpleExpressions);
                ((InputStream)is).close();
                csimpleExpressions.addAll(fileSimpleExpressions);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error parsing xml file " + file + " code due " + e.getMessage()), (Throwable)e);
            }
        }
        if (!csimpleExpressions.isEmpty()) {
            this.getLog().info((CharSequence)("Discovered " + csimpleExpressions.size() + " csimple expressions"));
            ArrayList<CSimpleGeneratedCode> classes = new ArrayList<CSimpleGeneratedCode>();
            for (CamelCSimpleExpressionDetails cs : csimpleExpressions) {
                String script = cs.getCsimple();
                String fqn2 = cs.getClassName();
                if (script != null && fqn2 == null) {
                    fqn2 = "org.apache.camel.language.csimple.XmlRouteBuilder";
                }
                if (script == null) continue;
                CSimpleGeneratedCode code = cs.isPredicate() ? generator.generatePredicate(fqn2, script) : generator.generateExpression(fqn2, script);
                classes.add(code);
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("Generated source code:\n\n\n" + code.getCode() + "\n\n\n"));
                }
                String fileName = code.getFqn().replace('.', '/') + ".java";
                this.outputDir.mkdirs();
                boolean saved = GenerateMojo.updateResource(this.outputDir.toPath().resolve(fileName), code.getCode());
                if (!saved) continue;
                this.getLog().info((CharSequence)("Generated csimple source code file: " + fileName));
            }
            if (!classes.isEmpty()) {
                StringWriter stringWriter = new StringWriter();
                stringWriter.append("# Generated by camel build tools - do NOT edit this file!\n");
                classes.forEach(c -> w.write(c.getFqn() + "\n"));
                String fileName = RESOURCE_FILE;
                this.outputResourceDir.mkdirs();
                boolean saved = GenerateMojo.updateResource(this.outputResourceDir.toPath().resolve(fileName), stringWriter.toString());
                if (saved) {
                    this.getLog().info((CharSequence)("Generated csimple resource file: " + fileName));
                }
            }
        }
    }

    private void loadConfiguration() {
        String[] lines;
        String loaded;
        String configFile = this.resourceDir.getPath() + "/camel-csimple.properties";
        FileInputStream is = null;
        try {
            File file = new File(configFile);
            if (file.exists()) {
                is = new FileInputStream(file);
            }
            if (is == null) {
                return;
            }
            loaded = IOHelper.loadText(is);
        }
        catch (IOException e) {
            throw new RuntimeCamelException("Cannot load " + configFile);
        }
        IOHelper.close((Closeable)is);
        int counter1 = 0;
        int counter2 = 0;
        for (String line : lines = loaded.split("\n")) {
            if ((line = line.trim()).startsWith("#")) continue;
            if (line.startsWith("import ")) {
                this.imports.add(line);
                ++counter1;
                continue;
            }
            String key = StringHelper.before((String)line, (String)"=");
            String value = StringHelper.after((String)line, (String)"=");
            if (key != null) {
                key = key.trim();
            }
            if (value != null) {
                value = value.trim();
            }
            if (key == null || value == null) continue;
            this.aliases.put(key, value);
            ++counter2;
        }
        if (counter1 > 0 || counter2 > 0) {
            this.getLog().info((CharSequence)("Loaded csimple language imports: " + counter1 + " and aliases: " + counter2 + " from configuration: " + configFile));
        }
    }

    private void findJavaFiles(File dir, Set<File> javaFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".java")) {
                    javaFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findJavaFiles(file, javaFiles);
            }
        }
    }

    private void findXmlFiles(File dir, Set<File> xmlFiles) {
        File[] files;
        File[] fileArray = files = dir.isDirectory() ? dir.listFiles() : null;
        if (files != null) {
            for (File file : files) {
                if (file.getName().endsWith(".xml")) {
                    xmlFiles.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.findXmlFiles(file, xmlFiles);
            }
        }
    }

    private boolean matchRouteFile(File file) {
        boolean match;
        if (this.excludes == null && this.includes == null) {
            return true;
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes.split(",")) {
                match = this.isMatch(exclude, file);
                if (!match) continue;
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes.split(",")) {
                match = this.isMatch(include, file);
                if (!match) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isMatch(String include, File file) {
        include = include.trim();
        String fqn = this.stripRootPath(this.asRelativeFile(file.getAbsolutePath()));
        return PatternHelper.matchPattern((String)fqn, (String)include) || PatternHelper.matchPattern((String)file.getName(), (String)include);
    }

    private String asRelativeFile(String name) {
        String answer = name;
        String base = this.project.getBasedir().getAbsolutePath();
        if (name.startsWith(base) && (answer = name.substring(base.length())).startsWith(File.separator)) {
            answer = answer.substring(1);
        }
        return answer;
    }

    private String stripRootPath(String name) {
        String compileSourceRoot = this.findInCompileSourceRoots(name);
        if (compileSourceRoot != null) {
            return compileSourceRoot;
        }
        String buildPath = this.findInResources(name);
        if (buildPath != null) {
            return buildPath;
        }
        return name;
    }

    private String findInCompileSourceRoots(String name) {
        String compileSourceRoot = this.findInCompileSourceRoots(this.project.getCompileSourceRoots(), name);
        if (compileSourceRoot != null) {
            return compileSourceRoot;
        }
        return this.findInCompileSourceRoots(this.project.getTestCompileSourceRoots(), name);
    }

    private String findInCompileSourceRoots(List<String> list, String name) {
        for (String dir : list) {
            if (!name.startsWith(dir = this.asRelativeFile(dir))) continue;
            return name.substring(dir.length() + 1);
        }
        return null;
    }

    private String findInResources(String name) {
        String buildPath = this.findInResources(this.project.getResources(), name);
        if (buildPath != null) {
            return buildPath;
        }
        return this.findInResources(this.project.getTestResources(), name);
    }

    private String findInResources(List<Resource> resources, String name) {
        for (Resource resource : resources) {
            String dir = this.asRelativeFile(resource.getDirectory());
            if (!name.startsWith(dir)) continue;
            return name.substring(dir.length() + 1);
        }
        return null;
    }

    public static boolean updateResource(Path out, String data) {
        try {
            if (FileUtil.updateFile((Path)out, (String)data)) {
                return true;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return false;
    }
}

