/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.converter.crypto.CryptoDataFormat;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class CryptoDataFormatConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        CryptoDataFormat target = (CryptoDataFormat)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                target.setAlgorithm((String)CryptoDataFormatConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "algorithmparameterspec": 
            case "algorithmParameterSpec": {
                target.setAlgorithmParameterSpec((AlgorithmParameterSpec)CryptoDataFormatConfigurer.property((CamelContext)camelContext, AlgorithmParameterSpec.class, (Object)value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                target.setBufferSize((Integer)CryptoDataFormatConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "cryptoprovider": 
            case "cryptoProvider": {
                target.setCryptoProvider((String)CryptoDataFormatConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "initvector": 
            case "initVector": {
                target.setInitVector((byte[])CryptoDataFormatConfigurer.property((CamelContext)camelContext, byte[].class, (Object)value));
                return true;
            }
            case "inline": {
                target.setInline((Boolean)CryptoDataFormatConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "key": {
                target.setKey((Key)CryptoDataFormatConfigurer.property((CamelContext)camelContext, Key.class, (Object)value));
                return true;
            }
            case "macalgorithm": 
            case "macAlgorithm": {
                target.setMacAlgorithm((String)CryptoDataFormatConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "shouldappendhmac": 
            case "shouldAppendHMAC": {
                target.setShouldAppendHMAC((Boolean)CryptoDataFormatConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return String.class;
            }
            case "algorithmparameterspec": 
            case "algorithmParameterSpec": {
                return AlgorithmParameterSpec.class;
            }
            case "buffersize": 
            case "bufferSize": {
                return Integer.TYPE;
            }
            case "cryptoprovider": 
            case "cryptoProvider": {
                return String.class;
            }
            case "initvector": 
            case "initVector": {
                return byte[].class;
            }
            case "inline": {
                return Boolean.TYPE;
            }
            case "key": {
                return Key.class;
            }
            case "macalgorithm": 
            case "macAlgorithm": {
                return String.class;
            }
            case "shouldappendhmac": 
            case "shouldAppendHMAC": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        CryptoDataFormat target = (CryptoDataFormat)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return target.getAlgorithm();
            }
            case "algorithmparameterspec": 
            case "algorithmParameterSpec": {
                return target.getAlgorithmParameterSpec();
            }
            case "buffersize": 
            case "bufferSize": {
                return target.getBufferSize();
            }
            case "cryptoprovider": 
            case "cryptoProvider": {
                return target.getCryptoProvider();
            }
            case "initvector": 
            case "initVector": {
                return target.getInitVector();
            }
            case "inline": {
                return target.isInline();
            }
            case "key": {
                return target.getKey();
            }
            case "macalgorithm": 
            case "macAlgorithm": {
                return target.getMacAlgorithm();
            }
            case "shouldappendhmac": 
            case "shouldAppendHMAC": {
                return target.isShouldAppendHMAC();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Algorithm", String.class);
        map.put("AlgorithmParameterSpec", AlgorithmParameterSpec.class);
        map.put("BufferSize", Integer.TYPE);
        map.put("CryptoProvider", String.class);
        map.put("InitVector", byte[].class);
        map.put("Inline", Boolean.TYPE);
        map.put("Key", Key.class);
        map.put("MacAlgorithm", String.class);
        map.put("ShouldAppendHMAC", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

