/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.toolbox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.builder.AggregationStrategies;
import org.apache.camel.builder.FlexibleAggregationStrategy;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.language.xpath.XPathBuilder;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Node;

public class FlexibleAggregationStrategiesTest
extends ContextTestSupport {
    private final CountDownLatch completionLatch = new CountDownLatch(1);
    private final CountDownLatch timeoutLatch = new CountDownLatch(1);

    @Test
    public void testFlexibleAggregationStrategyNoCondition() throws Exception {
        this.getMockEndpoint("mock:result1").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result1").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE1", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE2", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE3", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE4", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE5", "id", (Object)"123");
        this.assertMockEndpointsSatisfied();
        List resultList = (List)((Exchange)this.getMockEndpoint("mock:result1").getReceivedExchanges().get(0)).getIn().getBody(List.class);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((Object)("AGGREGATE" + (i + 1)), resultList.get(i));
        }
    }

    @Test
    public void testFlexibleAggregationStrategyCondition() throws Exception {
        this.getMockEndpoint("mock:result1").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result1").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE1", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"DISCARD", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE2", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"DISCARD", "id", (Object)"123");
        this.template.sendBodyAndHeader("direct:start1", (Object)"AGGREGATE3", "id", (Object)"123");
        this.assertMockEndpointsSatisfied();
        List resultList = (List)((Exchange)this.getMockEndpoint("mock:result1").getReceivedExchanges().get(0)).getIn().getBody(List.class);
        for (int i = 0; i < 3; ++i) {
            Assertions.assertEquals((Object)("AGGREGATE" + (i + 1)), resultList.get(i));
        }
    }

    @Test
    public void testFlexibleAggregationStrategyStoreInPropertyHashSet() throws Exception {
        this.getMockEndpoint("mock:result2").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result2").message(0).exchangeProperty("AggregationResult")).isInstanceOf(HashSet.class);
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"AGGREGATE1");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"DISCARD");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"AGGREGATE2");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"DISCARD");
        this.template.sendBodyAndHeader("direct:start2", (Object)"ignored body", "input", (Object)"AGGREGATE3");
        this.assertMockEndpointsSatisfied();
        HashSet resultSet = (HashSet)((Exchange)this.getMockEndpoint("mock:result2").getReceivedExchanges().get(0)).getProperty("AggregationResult", HashSet.class);
        Assertions.assertEquals((int)3, (int)resultSet.size());
        Assertions.assertTrue((resultSet.contains("AGGREGATE1") && resultSet.contains("AGGREGATE2") && resultSet.contains("AGGREGATE3") ? 1 : 0) != 0);
    }

    @Test
    public void testFlexibleAggregationStrategyStoreInHeaderSingleValue() throws Exception {
        this.getMockEndpoint("mock:result3").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result3").message(0).header("AggregationResult")).isInstanceOf(String.class);
        ((MockValueBuilder)this.getMockEndpoint("mock:result3").message(0).header("AggregationResult")).isEqualTo((Object)"AGGREGATE3");
        this.template.sendBody("direct:start3", (Object)"AGGREGATE1");
        this.template.sendBody("direct:start3", (Object)"AGGREGATE2");
        this.template.sendBody("direct:start3", (Object)"AGGREGATE3");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyStoreInVariableSingleValue() throws Exception {
        this.getMockEndpoint("mock:result7").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result7").message(0).variable("AggregationResult")).isInstanceOf(String.class);
        ((MockValueBuilder)this.getMockEndpoint("mock:result7").message(0).variable("AggregationResult")).isEqualTo((Object)"AGGREGATE1");
        this.template.sendBody("direct:start7", (Object)"AGGREGATE1");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyGenericArrayListWithoutNulls() throws Exception {
        this.getMockEndpoint("mock:result4").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result4").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBody("direct:start4", (Object)"AGGREGATE1");
        this.template.sendBody("direct:start4", (Object)123.0);
        this.template.sendBody("direct:start4", null);
        this.assertMockEndpointsSatisfied();
        ArrayList list = (ArrayList)((Exchange)this.getMockEndpoint("mock:result4").getReceivedExchanges().get(0)).getIn().getBody(ArrayList.class);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertTrue((boolean)list.contains("AGGREGATE1"));
        Assertions.assertTrue((boolean)list.contains(123.0));
    }

    @Test
    public void testFlexibleAggregationStrategyFailWithInvalidCast() throws Exception {
        this.getMockEndpoint("mock:result5").expectedMessageCount(0);
        Exception ex = (Exception)Assertions.assertThrows(Exception.class, () -> this.template.sendBody("direct:start5", (Object)"AGGREGATE1"), (String)"Type Conversion exception expected, as we are not ignoring invalid casts");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyFailOnInvalidCast() throws Exception {
        this.getMockEndpoint("mock:result6").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result6").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBody("direct:start6", (Object)"AGGREGATE1");
        this.template.sendBody("direct:start6", (Object)"AGGREGATE2");
        this.template.sendBody("direct:start6", (Object)"AGGREGATE3");
        this.assertMockEndpointsSatisfied();
        ArrayList list = (ArrayList)((Exchange)this.getMockEndpoint("mock:result6").getReceivedExchanges().get(0)).getIn().getBody(ArrayList.class);
        Assertions.assertEquals((int)3, (int)list.size());
        for (Object object : list) {
            Assertions.assertNull(object);
        }
    }

    @Test
    public void testFlexibleAggregationStrategyTimeoutCompletionMixins() throws Exception {
        this.getMockEndpoint("mock:result.timeoutAndCompletionAware").expectedMessageCount(2);
        ((MockValueBuilder)this.getMockEndpoint("mock:result.timeoutAndCompletionAware").message(0).body()).isEqualTo((Object)"AGGREGATE1");
        ((MockValueBuilder)this.getMockEndpoint("mock:result.timeoutAndCompletionAware").message(0).exchangeProperty("Timeout")).isEqualTo((Object)true);
        ((MockValueBuilder)this.getMockEndpoint("mock:result.timeoutAndCompletionAware").message(1).body()).isEqualTo((Object)"AGGREGATE3");
        this.template.sendBody("direct:start.timeoutAndCompletionAware", (Object)"AGGREGATE1");
        Assertions.assertTrue((boolean)this.timeoutLatch.await(2500L, TimeUnit.MILLISECONDS));
        this.template.sendBody("direct:start.timeoutAndCompletionAware", (Object)"AGGREGATE2");
        this.template.sendBody("direct:start.timeoutAndCompletionAware", (Object)"AGGREGATE3");
        Assertions.assertTrue((boolean)this.completionLatch.await(2500L, TimeUnit.MILLISECONDS));
        this.getMockEndpoint("mock:result.timeoutAndCompletionAware").getReceivedExchanges();
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFlexibleAggregationStrategyPickXPath() throws Exception {
        this.getMockEndpoint("mock:result.xpath1").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result.xpath1").message(0).body()).isInstanceOf(ArrayList.class);
        this.template.sendBody("direct:start.xpath1", (Object)"<envelope><result>ok</result></envelope>");
        this.template.sendBody("direct:start.xpath1", (Object)"<envelope><result>error</result></envelope>");
        this.template.sendBody("direct:start.xpath1", (Object)"<envelope>no result</envelope>");
        this.assertMockEndpointsSatisfied();
        ArrayList list = (ArrayList)((Exchange)this.getMockEndpoint("mock:result.xpath1").getReceivedExchanges().get(0)).getIn().getBody(ArrayList.class);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)"ok", (Object)((Node)list.get(0)).getTextContent());
        Assertions.assertEquals((Object)"error", (Object)((Node)list.get(1)).getTextContent());
    }

    @Test
    public void testLinkedList() {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).and().whenExactlyFailed(0).create();
        this.template.sendBody("direct:linkedlist", Arrays.asList("FIRST", "SECOND"));
        Assertions.assertTrue((boolean)notify.matches(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testHashSet() {
        HashSet<String> r = new HashSet<String>();
        r.add("FIRST");
        r.add("SECOND");
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).and().whenExactlyFailed(0).create();
        Set result = (Set)this.template.requestBody("direct:hashset", Arrays.asList("FIRST", "SECOND"), Set.class);
        Assertions.assertTrue((boolean)notify.matches(10L, TimeUnit.SECONDS));
        Assertions.assertEquals(r, (Object)result);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((AggregateDefinition)this.from("direct:start1").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).accumulateInCollection(ArrayList.class).pick((Expression)this.simple("${body}")).condition((Predicate)this.simple("${body} contains 'AGGREGATE'"))).header("id")).completionSize(5).to("mock:result1");
                ((AggregateDefinition)this.from("direct:start2").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).accumulateInCollection(HashSet.class).pick((Expression)this.simple("${header.input}")).condition((Predicate)this.simple("${header.input} contains 'AGGREGATE'")).storeInProperty("AggregationResult")).constant((Object)true)).completionSize(5).to("mock:result2");
                ((AggregateDefinition)this.from("direct:start3").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).storeInHeader("AggregationResult")).constant((Object)true)).completionSize(3).to("mock:result3");
                ((AggregateDefinition)this.from("direct:start4").aggregate((AggregationStrategy)AggregationStrategies.flexible().accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result4");
                ((AggregateDefinition)this.from("direct:start5").aggregate((AggregationStrategy)AggregationStrategies.flexible(Integer.class).accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result5");
                ((AggregateDefinition)this.from("direct:start6").aggregate((AggregationStrategy)AggregationStrategies.flexible(Integer.class).ignoreInvalidCasts().storeNulls().accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result6");
                ((AggregateDefinition)this.from("direct:start7").aggregate((AggregationStrategy)AggregationStrategies.flexible(String.class).storeInVariable("AggregationResult")).constant((Object)true)).completionSize(1).to("mock:result7");
                FlexibleAggregationStrategy timeoutCompletionStrategy = AggregationStrategies.flexible(String.class).condition((Predicate)this.simple("${body} contains 'AGGREGATE'")).timeoutAware(new FlexibleAggregationStrategy.TimeoutAwareMixin(){

                    public void timeout(Exchange exchange, int index, int total, long timeout) {
                        exchange.setProperty("Timeout", (Object)true);
                        FlexibleAggregationStrategiesTest.this.timeoutLatch.countDown();
                    }
                }).completionAware(new FlexibleAggregationStrategy.CompletionAwareMixin(){

                    public void onCompletion(Exchange exchange) {
                        FlexibleAggregationStrategiesTest.this.completionLatch.countDown();
                    }
                });
                ((AggregateDefinition)this.from("direct:start.timeoutAndCompletionAware").aggregate((AggregationStrategy)timeoutCompletionStrategy).constant((Object)true)).completionTimeout(500L).completionSize(2).to("mock:result.timeoutAndCompletionAware");
                ((AggregateDefinition)this.from("direct:start.xpath1").aggregate((AggregationStrategy)AggregationStrategies.flexible(Node.class).pick((Expression)XPathBuilder.xpath((String)"//result[1]").nodeResult()).accumulateInCollection(ArrayList.class)).constant((Object)true)).completionSize(3).to("mock:result.xpath1");
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:linkedlist").log(LoggingLevel.INFO, "Before the first split the body is ${body} and has class ${body.getClass()}")).split((Expression)this.body(), (AggregationStrategy)AggregationStrategies.flexible().pick((Expression)this.body()).accumulateInCollection(LinkedList.class)).log(LoggingLevel.INFO, "During the first split the body is ${body} and has class ${body.getClass()}")).end().log(LoggingLevel.INFO, "Before the second split the body is ${body} and has class ${body.getClass()}").split((Expression)this.body(), (AggregationStrategy)AggregationStrategies.flexible().pick((Expression)this.body()).accumulateInCollection(LinkedList.class)).log(LoggingLevel.INFO, "During the second split the body is ${body} and has class ${body.getClass()}")).end().log(LoggingLevel.INFO, "After the second split the body is ${body} and has class ${body.getClass()}");
                ((ExpressionNode)((ExpressionNode)((RouteDefinition)this.from("direct:hashset").log(LoggingLevel.INFO, "Before the first split the body is ${body} and has class ${body.getClass()}")).split((Expression)this.body(), (AggregationStrategy)AggregationStrategies.flexible().pick((Expression)this.body()).accumulateInCollection(HashSet.class)).log(LoggingLevel.INFO, "During the first split the body is ${body} and has class ${body.getClass()}")).end().log(LoggingLevel.INFO, "Before the second split the body is ${body} and has class ${body.getClass()}").split((Expression)this.body(), (AggregationStrategy)AggregationStrategies.flexible().pick((Expression)this.body()).accumulateInCollection(HashSet.class)).log(LoggingLevel.INFO, "During the second split the body is ${body} and has class ${body.getClass()}")).end().log(LoggingLevel.INFO, "After the second split the body is ${body} and has class ${body.getClass()}");
            }
        };
    }
}

