/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UnsafeCharactersEncoderTest {
    private void testEncoding(String before, String after) {
        String result = UnsafeUriCharactersEncoder.encode((String)before);
        Assertions.assertEquals((Object)after, (Object)result, (String)"Get the wrong encoding result");
    }

    @Test
    public void testQnameEncoder() {
        String afterEncoding = "%7Bhttp://www.example.com/test%7DServiceName";
        String beforeEncoding = "{http://www.example.com/test}ServiceName";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testNoEncoding() {
        String noEncoding = "http://www.example.com";
        this.testEncoding(noEncoding, noEncoding);
    }

    @Test
    public void testUnicodes() {
        String noEncoding = "http://test.com/\ufd04";
        this.testEncoding(noEncoding, noEncoding);
    }

    @Test
    public void testPercentEncode() {
        String beforeEncoding = "sql:select * from foo where bar like '%A'";
        String afterEncoding = "sql:select%20*%20from%20foo%20where%20bar%20like%20'%25A'";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testPercentEncodeAlready() {
        String beforeEncoding = "sql:select * from foo where bar like '%25A'";
        String afterEncoding = "sql:select%20*%20from%20foo%20where%20bar%20like%20'%25A'";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testPercentEncodeDanishChar() {
        String beforeEncoding = "http://localhost:{{port}}/myapp/mytest?columns=claus,s\u00f8ren&username=apiuser";
        String afterEncoding = "http://localhost:%7B%7Bport%7D%7D/myapp/mytest?columns=claus,s\u00f8ren&username=apiuser";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testPercentEncodeDanishCharEncoded() {
        String beforeEncoding = "http://localhost:{{port}}/myapp/mytest?columns=claus,s%C3%B8ren&username=apiuser";
        String afterEncoding = "http://localhost:%7B%7Bport%7D%7D/myapp/mytest?columns=claus,s%C3%B8ren&username=apiuser";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testAlreadyEncoded() {
        String beforeEncoding = "http://www.example.com?query=foo%20bar";
        String afterEncoding = "http://www.example.com?query=foo%20bar";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testPercentEncodedLast() {
        String beforeEncoding = "http://www.example.com?like=foo%25";
        String afterEncoding = "http://www.example.com?like=foo%25";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testPlusInQuery() {
        String beforeEncoding = "http://www.example.com?param1=%2B447777111222";
        String afterEncoding = "http://www.example.com?param1=%2B447777111222";
        this.testEncoding(beforeEncoding, afterEncoding);
        beforeEncoding = "http://www.example.com?param1=+447777111222";
        afterEncoding = "http://www.example.com?param1=+447777111222";
        this.testEncoding(beforeEncoding, afterEncoding);
    }

    @Test
    public void testPasswordEncodingInRawMode() {
        String password = "RAW(%j#7%c6i)";
        String result = UnsafeUriCharactersEncoder.encode((String)password, (boolean)true);
        result = result.substring(4);
        result = result.substring(0, result.length() - 1);
        String expected = "%25j%237%25c6i";
        Assertions.assertEquals((Object)result, (Object)expected, (String)"Get the wrong encoding result");
    }
}

