/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.StringQuoteHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StingQuoteHelperTest {
    @Test
    public void testSplitSafeQuote() {
        Assertions.assertNull((Object)StringQuoteHelper.splitSafeQuote(null, (char)','));
        String[] out = StringQuoteHelper.splitSafeQuote((String)"", (char)',');
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"   ", (char)',');
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"   ", (char)',', (boolean)false);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"   ", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"Camel", (char)',');
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"Camel", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"Hello Camel", (char)',');
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"Hello,Camel", (char)',');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        Assertions.assertEquals((Object)"Camel", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"Hello,Camel,Bye,World", (char)',');
        Assertions.assertEquals((int)4, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        Assertions.assertEquals((Object)"Camel", (Object)out[1]);
        Assertions.assertEquals((Object)"Bye", (Object)out[2]);
        Assertions.assertEquals((Object)"World", (Object)out[3]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello,Camel','Bye,World'", (char)',');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello,Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"Bye,World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello,Camel',\"Bye,World\"", (char)',');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello,Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"Bye,World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello,Camel\",'Bye,World'", (char)',');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello,Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"Bye,World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello,Camel\",\"Bye,World\"", (char)',');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello,Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"Bye,World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel', 'Bye World'", (char)',');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"Bye World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel',' Bye World'", (char)',', (boolean)false);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out[0]);
        Assertions.assertEquals((Object)" Bye World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'http:',' '", (char)',', (boolean)false);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"http:", (Object)out[0]);
        Assertions.assertEquals((Object)" ", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'http:',''", (char)',', (boolean)false);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"http:", (Object)out[0]);
        Assertions.assertEquals((Object)"", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel',5,true", (char)',', (boolean)false);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"true", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello Camel',5,true", (char)',', (boolean)false);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"true", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"   'Hello Camel',  5   ,  true   ", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello Camel", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"true", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"*, '', 'arg3'", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"*", (Object)out[0]);
        Assertions.assertEquals((Object)"", (Object)out[1]);
        Assertions.assertEquals((Object)"arg3", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello'", (char)',', (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)" Hello ", (char)',', (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"' Hello '", (char)',', (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)" Hello ", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"' Hello '", (char)',', (boolean)false);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)" Hello ", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello', 'World'", (char)',', (boolean)true);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        Assertions.assertEquals((Object)"World", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello\"", (char)',', (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)" Hello ", (char)',', (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"\" Hello \"", (char)',', (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)" Hello ", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"\" Hello \"", (char)',', (boolean)false);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)" Hello ", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello\", \"World\"", (char)',', (boolean)true);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"Hello", (Object)out[0]);
        Assertions.assertEquals((Object)"World", (Object)out[1]);
    }

    @Test
    public void testLastIsQuote() {
        String[] out = StringQuoteHelper.splitSafeQuote((String)" ${body}, 5, 'Hello World'", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"${body}", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"Hello World", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)" ${body}, 5, \"Hello World\"", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"${body}", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"Hello World", (Object)out[2]);
    }

    @Test
    public void testSingleInDoubleQuote() {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"\"Hello O'Connor\", 5, 'foo bar'", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello O'Connor", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"foo bar", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"\"Hello O'Connor O'Bannon\", 5, 'foo bar'", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello O'Connor O'Bannon", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"foo bar", (Object)out[2]);
    }

    @Test
    public void testDoubleInSingleQuote() {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"'Hello O\"Connor', 5, 'foo bar'", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello O\"Connor", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"foo bar", (Object)out[2]);
        out = StringQuoteHelper.splitSafeQuote((String)"'Hello O\"Connor O\"Bannon', 5, 'foo bar'", (char)',', (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"Hello O\"Connor O\"Bannon", (Object)out[0]);
        Assertions.assertEquals((Object)"5", (Object)out[1]);
        Assertions.assertEquals((Object)"foo bar", (Object)out[2]);
    }

    @Test
    public void testSpaceSeparator() {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"dependency=mvn:org.my:application:1.0 dependency=mvn:com.foo:myapp:2.1", (char)' ');
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"dependency=mvn:org.my:application:1.0", (Object)out[0]);
        Assertions.assertEquals((Object)"dependency=mvn:com.foo:myapp:2.1", (Object)out[1]);
    }

    @Test
    public void testSpaceSeparatorQuote() {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"dependency=mvn:org.my:application:1.0 property=hi='Hello World' dependency=mvn:com.foo:myapp:2.1", (char)' ');
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"dependency=mvn:org.my:application:1.0", (Object)out[0]);
        Assertions.assertEquals((Object)"property=hi=Hello World", (Object)out[1]);
        Assertions.assertEquals((Object)"dependency=mvn:com.foo:myapp:2.1", (Object)out[2]);
    }

    @Test
    public void testKeepQuotes() {
        String[] out = StringQuoteHelper.splitSafeQuote((String)"'body'", (char)',', (boolean)false, (boolean)true);
        Assertions.assertEquals((int)1, (int)out.length);
        Assertions.assertEquals((Object)"'body'", (Object)out[0]);
        out = StringQuoteHelper.splitSafeQuote((String)"'body',123", (char)',', (boolean)false, (boolean)true);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"'body'", (Object)out[0]);
        Assertions.assertEquals((Object)"123", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'body',\"world\"", (char)',', (boolean)false, (boolean)true);
        Assertions.assertEquals((int)2, (int)out.length);
        Assertions.assertEquals((Object)"'body'", (Object)out[0]);
        Assertions.assertEquals((Object)"\"world\"", (Object)out[1]);
        out = StringQuoteHelper.splitSafeQuote((String)"'body',\"world\",123", (char)',', (boolean)false, (boolean)true);
        Assertions.assertEquals((int)3, (int)out.length);
        Assertions.assertEquals((Object)"'body'", (Object)out[0]);
        Assertions.assertEquals((Object)"\"world\"", (Object)out[1]);
        Assertions.assertEquals((Object)"123", (Object)out[2]);
    }
}

