/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPOutputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.engine.DefaultResourceLoader;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.ResourceResolver;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.support.ResourceResolverSupport;
import org.apache.camel.util.CollectionHelper;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceLoaderTest
extends TestSupport {
    @Test
    public void testLoadFile() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("file:src/test/resources/log4j2.properties");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertTrue((boolean)text.contains("rootLogger"));
        }
    }

    @Test
    public void testLoadFileWithSpace() throws Exception {
        this.testDirectory("target/data/my space", true);
        FileUtil.copyFile((File)new File("src/test/resources/log4j2.properties"), (File)this.testFile("target/data/my space/log4j2.properties").toFile());
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("file:" + this.testDirectory().toString() + "/target/data/my%20space/log4j2.properties");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertTrue((boolean)text.contains("rootLogger"));
        }
    }

    @Test
    public void testLoadClasspath() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("classpath:log4j2.properties");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertTrue((boolean)text.contains("rootLogger"));
        }
    }

    @Test
    public void testLoadClasspathDefault() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("log4j2.properties");
            context.start();
            try (InputStream is = resource.getInputStream();){
                Assertions.assertNotNull((Object)is);
                String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
                Assertions.assertNotNull((Object)text);
                Assertions.assertTrue((boolean)text.contains("rootLogger"));
            }
        }
    }

    @Test
    public void testLoadFallback() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            DefaultResourceLoader loader = ResourceLoaderTest.createDefaultResourceLoader();
            context.getCamelContextExtension().addContextPlugin(ResourceLoader.class, (Object)loader);
            Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("log4j2.properties");
            context.start();
            try (InputStream is = resource.getInputStream();){
                Assertions.assertNotNull((Object)is);
                String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
                Assertions.assertNotNull((Object)text);
                Assertions.assertEquals((Object)"fallback", (Object)text);
            }
        }
    }

    private static DefaultResourceLoader createDefaultResourceLoader() {
        DefaultResourceLoader loader = new DefaultResourceLoader();
        loader.setFallbackResolver((ResourceResolver)new ResourceResolverSupport("custom"){

            public Resource resolve(String location) {
                return ResourceHelper.fromString((String)"custom", (String)"fallback");
            }

            protected Resource createResource(String location, String remaining) {
                throw new UnsupportedOperationException();
            }
        });
        return loader;
    }

    @Test
    public void testLoadRegistry() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("myBean", (Object)"This is a log4j logging configuration file");
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("ref:myBean");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertTrue((boolean)text.contains("log4j"));
        }
    }

    @Test
    public void testLoadBeanDoubleColon() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("myBean", new AtomicReference<ByteArrayInputStream>(new ByteArrayInputStream("a".getBytes())));
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("bean:myBean::get");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertEquals((Object)"a", (Object)text);
        }
    }

    @Test
    public void testLoadBeanDoubleColonLong() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("my.company.MyClass", new AtomicReference<ByteArrayInputStream>(new ByteArrayInputStream("a".getBytes())));
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("bean:my.company.MyClass::get");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertEquals((Object)"a", (Object)text);
        }
    }

    @Test
    public void testLoadBeanDot() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.getCamelContextExtension().getRegistry().bind("myBean", new AtomicReference<ByteArrayInputStream>(new ByteArrayInputStream("a".getBytes())));
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("bean:myBean.get");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)text);
            Assertions.assertEquals((Object)"a", (Object)text);
        }
    }

    @Test
    public void testLoadFileNotFound() {
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("file:src/test/resources/notfound.txt");
        Assertions.assertFalse((boolean)resource.exists());
    }

    @Test
    public void testLoadClasspathNotFound() {
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("classpath:notfound.txt");
        Assertions.assertFalse((boolean)resource.exists());
    }

    @Test
    public void testLoadFileAsUrl() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("file:src/test/resources/log4j2.properties");
        URL url = resource.getURI().toURL();
        Assertions.assertNotNull((Object)url);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)url);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        context.stop();
    }

    @Test
    public void testLoadClasspathAsUrl() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("classpath:log4j2.properties");
        URL url = resource.getURI().toURL();
        Assertions.assertNotNull((Object)url);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)url);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        context.stop();
    }

    @Test
    public void testLoadMem() throws Exception {
        String raw = "to-be-encoded";
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("mem:to-be-encoded");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String content = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)content);
            Assertions.assertEquals((Object)"to-be-encoded", (Object)content);
        }
    }

    @Test
    public void testLoadBase64() throws Exception {
        String raw = "to-be-encoded";
        String encoded = Base64.getEncoder().encodeToString("to-be-encoded".getBytes(StandardCharsets.UTF_8));
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("base64:" + encoded);
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String content = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)content);
            Assertions.assertEquals((Object)"to-be-encoded", (Object)content);
        }
    }

    @Test
    public void testLoadBase64WithPlaceholders() throws Exception {
        String raw = "to-be-encoded";
        String encoded = Base64.getEncoder().encodeToString("to-be-encoded".getBytes(StandardCharsets.UTF_8));
        DefaultCamelContext context = new DefaultCamelContext();
        context.getPropertiesComponent().setInitialProperties(CollectionHelper.propertiesOf((String)"my.encoded", (String)encoded, (String[])new String[0]));
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("base64:{{my.encoded}}");
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String content = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)content);
            Assertions.assertEquals((Object)"to-be-encoded", (Object)content);
        }
    }

    @Test
    public void testLoadGzip() throws Exception {
        String encoded;
        String raw = "to-be-encoded";
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            try (GZIPOutputStream gzip = new GZIPOutputStream(out);){
                gzip.write("to-be-encoded".getBytes(StandardCharsets.UTF_8));
            }
            encoded = Base64.getEncoder().encodeToString(out.toByteArray());
        }
        DefaultCamelContext context = new DefaultCamelContext();
        Resource resource = PluginHelper.getResourceLoader((CamelContext)context).resolveResource("gzip:" + encoded);
        try (InputStream is = resource.getInputStream();){
            Assertions.assertNotNull((Object)is);
            String content = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
            Assertions.assertNotNull((Object)content);
            Assertions.assertEquals((Object)"to-be-encoded", (Object)content);
        }
    }
}

