/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.CamelContext;
import org.apache.camel.TestSupport;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.DefaultRegistry;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceHelperTest
extends TestSupport {
    @Test
    public void testLoadFile() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"file:src/test/resources/log4j2.properties");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        is.close();
        context.stop();
    }

    @Test
    public void testLoadFileWithSpace() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.testDirectory("my space", true);
        FileUtil.copyFile((File)new File("src/test/resources/log4j2.properties"), (File)this.testFile("my space/log4j2.properties").toFile());
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)this.fileUri("my%20space/log4j2.properties"));
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        is.close();
        context.stop();
    }

    @Test
    public void testLoadClasspath() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"classpath:log4j2.properties");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        is.close();
        context.stop();
    }

    @Test
    public void testLoadRegistry() throws Exception {
        DefaultRegistry registry = new DefaultRegistry();
        registry.bind("myBean", (Object)"This is a log4j logging configuration file");
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"ref:myBean");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("log4j"));
        is.close();
        context.stop();
    }

    @Test
    public void testLoadBeanDoubleColon() throws Exception {
        DefaultRegistry registry = new DefaultRegistry();
        registry.bind("myBean", new AtomicReference<ByteArrayInputStream>(new ByteArrayInputStream("a".getBytes())));
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"bean:myBean::get");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertEquals((Object)"a", (Object)text);
        is.close();
        context.stop();
    }

    @Test
    public void testLoadBeanDoubleColonLong() throws Exception {
        DefaultRegistry registry = new DefaultRegistry();
        registry.bind("my.company.MyClass", new AtomicReference<ByteArrayInputStream>(new ByteArrayInputStream("a".getBytes())));
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"bean:my.company.MyClass::get");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertEquals((Object)"a", (Object)text);
        is.close();
        context.stop();
    }

    @Test
    public void testLoadBeanDot() throws Exception {
        DefaultRegistry registry = new DefaultRegistry();
        registry.bind("myBean", new AtomicReference<ByteArrayInputStream>(new ByteArrayInputStream("a".getBytes())));
        DefaultCamelContext context = new DefaultCamelContext((Registry)registry);
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"bean:myBean.get");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertEquals((Object)"a", (Object)text);
        is.close();
        context.stop();
    }

    @Test
    public void testLoadClasspathDefault() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"log4j2.properties");
        Assertions.assertNotNull((Object)is);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)is);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        is.close();
        context.stop();
    }

    @Test
    public void testLoadFileNotFound() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        try {
            ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"file:src/test/resources/notfound.txt");
            Assertions.fail((String)"Should not find file");
        }
        catch (FileNotFoundException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("notfound.txt"));
        }
        context.stop();
    }

    @Test
    public void testLoadClasspathNotFound() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        try {
            ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)context, (String)"classpath:notfound.txt");
            Assertions.fail((String)"Should not find file");
        }
        catch (FileNotFoundException e) {
            Assertions.assertEquals((Object)"Cannot find resource: classpath:notfound.txt for URI: classpath:notfound.txt", (Object)e.getMessage());
        }
        context.stop();
    }

    @Test
    public void testLoadFileAsUrl() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        URL url = ResourceHelper.resolveMandatoryResourceAsUrl((CamelContext)context, (String)"file:src/test/resources/log4j2.properties");
        Assertions.assertNotNull((Object)url);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)url);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        context.stop();
    }

    @Test
    public void testLoadClasspathAsUrl() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        URL url = ResourceHelper.resolveMandatoryResourceAsUrl((CamelContext)context, (String)"classpath:log4j2.properties");
        Assertions.assertNotNull((Object)url);
        String text = (String)context.getTypeConverter().convertTo(String.class, (Object)url);
        Assertions.assertNotNull((Object)text);
        Assertions.assertTrue((boolean)text.contains("rootLogger"));
        context.stop();
    }

    @Test
    public void testIsHttp() {
        Assertions.assertFalse((boolean)ResourceHelper.isHttpUri((String)"direct:foo"));
        Assertions.assertFalse((boolean)ResourceHelper.isHttpUri((String)""));
        Assertions.assertFalse((boolean)ResourceHelper.isHttpUri(null));
        Assertions.assertTrue((boolean)ResourceHelper.isHttpUri((String)"http://camel.apache.org"));
        Assertions.assertTrue((boolean)ResourceHelper.isHttpUri((String)"https://camel.apache.org"));
    }

    @Test
    public void testIsClasspath() {
        Assertions.assertFalse((boolean)ResourceHelper.isClasspathUri((String)"direct:foo"));
        Assertions.assertFalse((boolean)ResourceHelper.isClasspathUri((String)"file:foo/bar.properties"));
        Assertions.assertFalse((boolean)ResourceHelper.isClasspathUri((String)"http://camel.apache.org"));
        Assertions.assertFalse((boolean)ResourceHelper.isClasspathUri((String)""));
        Assertions.assertFalse((boolean)ResourceHelper.isClasspathUri(null));
        Assertions.assertTrue((boolean)ResourceHelper.isClasspathUri((String)"classpath:foo/bar.properties"));
        Assertions.assertTrue((boolean)ResourceHelper.isClasspathUri((String)"foo/bar.properties"));
    }

    @Test
    public void testGetScheme() {
        Assertions.assertEquals((Object)"file:", (Object)ResourceHelper.getScheme((String)"file:myfile.txt"));
        Assertions.assertEquals((Object)"classpath:", (Object)ResourceHelper.getScheme((String)"classpath:myfile.txt"));
        Assertions.assertEquals((Object)"http:", (Object)ResourceHelper.getScheme((String)"http:www.foo.com"));
        Assertions.assertEquals((Object)"ref:", (Object)ResourceHelper.getScheme((String)"ref:myBean"));
        Assertions.assertNull((Object)ResourceHelper.getScheme((String)"www.foo.com"));
        Assertions.assertNull((Object)ResourceHelper.getScheme((String)"myfile.txt"));
    }

    @Test
    public void testAppendParameters() throws Exception {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("foo", 123);
        params.put("bar", "yes");
        Assertions.assertEquals((Object)"http://localhost:8080/data?foo=123&bar=yes", (Object)ResourceHelper.appendParameters((String)"http://localhost:8080/data", params));
        Assertions.assertEquals((int)0, (int)params.size());
    }

    @Test
    public void testBase64() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        Resource res = ResourceHelper.resolveResource((CamelContext)context, (String)"base64:SGVsbG8=");
        Assertions.assertTrue((boolean)res.exists());
        Assertions.assertEquals((Object)"Hello", (Object)context.getTypeConverter().convertTo(String.class, (Object)res.getInputStream()));
    }
}

