/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.camel.Ordered;
import org.apache.camel.support.OrderedComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OrderedComparatorTest {
    @Test
    public void testOrderedComparatorGet() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(1));
        answer.add(new MyOrder(5));
        answer.add(new MyOrder(4));
        answer.sort((Comparator<MyOrder>)OrderedComparator.get());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)1, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)4, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)5, (int)((Ordered)answer.get(4)).getOrder());
    }

    @Test
    public void testOrderedComparator() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(1));
        answer.add(new MyOrder(5));
        answer.add(new MyOrder(4));
        answer.sort((Comparator<MyOrder>)new OrderedComparator());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)1, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)4, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)5, (int)((Ordered)answer.get(4)).getOrder());
    }

    @Test
    public void testOrderedComparatorGetReverse() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(1));
        answer.add(new MyOrder(5));
        answer.add(new MyOrder(4));
        answer.sort((Comparator<MyOrder>)OrderedComparator.getReverse());
        Assertions.assertEquals((int)5, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)4, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)1, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(4)).getOrder());
    }

    @Test
    public void testOrderedComparatorReverse() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(1));
        answer.add(new MyOrder(5));
        answer.add(new MyOrder(4));
        answer.sort((Comparator<MyOrder>)new OrderedComparator(true));
        Assertions.assertEquals((int)5, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)4, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)1, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(4)).getOrder());
    }

    @Test
    public void testOrderedComparatorHigh() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(Integer.MIN_VALUE));
        answer.add(new MyOrder(4));
        answer.sort((Comparator<MyOrder>)new OrderedComparator());
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)2, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)4, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)50, (int)((Ordered)answer.get(4)).getOrder());
        Assertions.assertEquals((int)200, (int)((Ordered)answer.get(5)).getOrder());
    }

    @Test
    public void testOrderedComparatorHighReverse() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(Integer.MIN_VALUE));
        answer.add(new MyOrder(4));
        answer.sort((Comparator<MyOrder>)new OrderedComparator(true));
        Assertions.assertEquals((int)200, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)50, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)4, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)2, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(4)).getOrder());
        Assertions.assertEquals((int)Integer.MIN_VALUE, (int)((Ordered)answer.get(5)).getOrder());
    }

    @Test
    public void testOrderedComparatorLow() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(-2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(2147482647));
        answer.add(new MyOrder(-4));
        answer.sort((Comparator<MyOrder>)new OrderedComparator());
        Assertions.assertEquals((int)-4, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)-2, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)50, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)200, (int)((Ordered)answer.get(4)).getOrder());
        Assertions.assertEquals((int)2147482647, (int)((Ordered)answer.get(5)).getOrder());
    }

    @Test
    public void testOrderedComparatorLowReverse() {
        ArrayList<MyOrder> answer = new ArrayList<MyOrder>();
        answer.add(new MyOrder(0));
        answer.add(new MyOrder(-2));
        answer.add(new MyOrder(200));
        answer.add(new MyOrder(50));
        answer.add(new MyOrder(2147482647));
        answer.add(new MyOrder(-4));
        answer.sort((Comparator<MyOrder>)new OrderedComparator(true));
        Assertions.assertEquals((int)2147482647, (int)((Ordered)answer.get(0)).getOrder());
        Assertions.assertEquals((int)200, (int)((Ordered)answer.get(1)).getOrder());
        Assertions.assertEquals((int)50, (int)((Ordered)answer.get(2)).getOrder());
        Assertions.assertEquals((int)0, (int)((Ordered)answer.get(3)).getOrder());
        Assertions.assertEquals((int)-2, (int)((Ordered)answer.get(4)).getOrder());
        Assertions.assertEquals((int)-4, (int)((Ordered)answer.get(5)).getOrder());
    }

    private static final class MyOrder
    implements Ordered {
        private final int order;

        private MyOrder(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public String toString() {
            return Integer.toString(this.order);
        }
    }
}

