/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.List;
import org.apache.camel.util.OgnlHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OgnlHelperTest {
    @Test
    public void testSplitOgnlSimple() {
        List methods = OgnlHelper.splitOgnl(null);
        Assertions.assertEquals((int)0, (int)methods.size());
        methods = OgnlHelper.splitOgnl((String)"");
        Assertions.assertEquals((int)0, (int)methods.size());
        methods = OgnlHelper.splitOgnl((String)" ");
        Assertions.assertEquals((int)0, (int)methods.size());
        methods = OgnlHelper.splitOgnl((String)"foo");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo.bar");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo", methods.get(0));
        Assertions.assertEquals((Object)".bar", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo.bar.baz");
        Assertions.assertEquals((int)3, (int)methods.size());
        Assertions.assertEquals((Object)"foo", methods.get(0));
        Assertions.assertEquals((Object)".bar", methods.get(1));
        Assertions.assertEquals((Object)".baz", methods.get(2));
    }

    @Test
    public void testSplitOgnlSquare() {
        List methods = OgnlHelper.splitOgnl((String)"foo");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo[0].bar");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo[0]", methods.get(0));
        Assertions.assertEquals((Object)".bar", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo[0]?.bar");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo[0]", methods.get(0));
        Assertions.assertEquals((Object)"?.bar", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo['key'].bar");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo['key']", methods.get(0));
        Assertions.assertEquals((Object)".bar", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo['key']?.bar");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo['key']", methods.get(0));
        Assertions.assertEquals((Object)"?.bar", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo['key'].bar[0]");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo['key']", methods.get(0));
        Assertions.assertEquals((Object)".bar[0]", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo['key']?.bar[0]");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo['key']", methods.get(0));
        Assertions.assertEquals((Object)"?.bar[0]", methods.get(1));
    }

    @Test
    public void testSplitOgnlParenthesis() {
        List methods = OgnlHelper.splitOgnl((String)"foo()");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo()", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo(${body})");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body})", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo})");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body}, ${header.foo})", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body}, ${header.foo})", methods.get(0));
        Assertions.assertEquals((Object)".bar", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar(true, ${header.bar})");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body}, ${header.foo})", methods.get(0));
        Assertions.assertEquals((Object)".bar(true, ${header.bar})", methods.get(1));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar(true, ${header.bar}).baz['key']");
        Assertions.assertEquals((int)3, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body}, ${header.foo})", methods.get(0));
        Assertions.assertEquals((Object)".bar(true, ${header.bar})", methods.get(1));
        Assertions.assertEquals((Object)".baz['key']", methods.get(2));
    }

    @Test
    public void testSplitOgnlParenthesisAndBracket() {
        List methods = OgnlHelper.splitOgnl((String)"foo(${body['key']})");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body['key']})", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo?['key']})");
        Assertions.assertEquals((int)1, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body}, ${header.foo?['key']})", methods.get(0));
        methods = OgnlHelper.splitOgnl((String)"foo(${body}, ${header.foo}).bar(true, ${header.bar[0]?.code})");
        Assertions.assertEquals((int)2, (int)methods.size());
        Assertions.assertEquals((Object)"foo(${body}, ${header.foo})", methods.get(0));
        Assertions.assertEquals((Object)".bar(true, ${header.bar[0]?.code})", methods.get(1));
    }

    @Test
    public void testMethodAsDoubleQuotes() {
        String out = OgnlHelper.methodAsDoubleQuotes((String)"${bodyAs(String).compareTo('It\\'s a great World')}");
        Assertions.assertEquals((Object)"${bodyAs(String).compareTo(\"It's a great World\")}", (Object)out);
        out = OgnlHelper.methodAsDoubleQuotes((String)"${bodyAs(String).compareTo(\"It's a great World\")}");
        Assertions.assertEquals((Object)"${bodyAs(String).compareTo(\"It's a great World\")}", (Object)out);
    }
}

