/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.bean.MyOtherFooBean;
import org.apache.camel.component.bean.MyStaticClass;
import org.apache.camel.converter.stream.FileInputStreamCache;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.util.MyDummyObject;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectHelperTest {
    @Test
    void testLoadResourceAsStream() throws Exception {
        try (InputStream res1 = ObjectHelper.loadResourceAsStream((String)"org/apache/camel/util/ObjectHelperResourceTestFile.properties");
             InputStream res2 = ObjectHelper.loadResourceAsStream((String)"/org/apache/camel/util/ObjectHelperResourceTestFile.properties");){
            Assertions.assertNotNull((Object)res1, (String)"Cannot load resource without leading \"/\"");
            Assertions.assertNotNull((Object)res2, (String)"Cannot load resource with leading \"/\"");
        }
    }

    @Test
    void testLoadResource() {
        URL url1 = ObjectHelper.loadResourceAsURL((String)"org/apache/camel/util/ObjectHelperResourceTestFile.properties");
        URL url2 = ObjectHelper.loadResourceAsURL((String)"/org/apache/camel/util/ObjectHelperResourceTestFile.properties");
        Assertions.assertNotNull((Object)url1, (String)"Cannot load resource without leading \"/\"");
        Assertions.assertNotNull((Object)url2, (String)"Cannot load resource with leading \"/\"");
    }

    @Test
    void testGetPropertyName() throws Exception {
        Method method = this.getClass().getMethod("setCheese", String.class);
        Assertions.assertNotNull((Object)method, (String)"should have found a method!");
        String name = ObjectHelper.getPropertyName((Method)method);
        Assertions.assertEquals((Object)"cheese", (Object)name, (String)"Property name");
    }

    public void setCheese(String cheese) {
    }

    @Test
    void testContains() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.start();
            TypeConverter tc = context.getTypeConverter();
            String[] array = new String[]{"foo", "bar"};
            List<String> collection = Arrays.asList(array);
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)array, (Object)"foo", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)array, (Object)"FOO", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)array, (Object)"FOO", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, collection, (Object)"foo", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, collection, (Object)"FOO", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, collection, (Object)"FOO", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)"foo", (Object)"foo", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)array, (Object)"xyz", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, collection, (Object)"xyz", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)"foo", (Object)"xyz", (boolean)true));
        }
    }

    @Test
    void testContainsStreamCaching() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.start();
            TypeConverter tc = context.getTypeConverter();
            File file = new File("src/test/resources/org/apache/camel/util/quote.txt");
            FileInputStreamCache data = new FileInputStreamCache(file);
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"foo", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"foo", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)"foo", (Object)"foo", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"xyz", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)data, (Object)"xyz", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)"foo", (Object)"xyz", (boolean)true));
        }
    }

    @Test
    void testEqualsStreamCaching() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.start();
            TypeConverter tc = context.getTypeConverter();
            File file = new File("src/test/resources/org/apache/camel/util/foo.txt");
            FileInputStreamCache data = new FileInputStreamCache(file);
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"foo", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"foo", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"FOO", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)"foo", (Object)"foo", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"xyz", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)data, (Object)"xyz", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceEquals((TypeConverter)tc, (Object)"foo", (Object)"xyz", (boolean)true));
        }
    }

    @Test
    void testContainsStringBuilder() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.start();
            TypeConverter tc = context.getTypeConverter();
            StringBuilder sb = new StringBuilder();
            sb.append("Hello World");
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)"World", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)"WORLD", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)"WORLD", (boolean)false));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuffer("World"), (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuilder("World"), (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)"Camel", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuffer("Camel"), (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuilder("Camel"), (boolean)true));
        }
    }

    @Test
    void testContainsStringBuffer() throws Exception {
        try (DefaultCamelContext context = new DefaultCamelContext();){
            context.start();
            TypeConverter tc = context.getTypeConverter();
            StringBuffer sb = new StringBuffer();
            sb.append("Hello World");
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)"World", (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuffer("World"), (boolean)true));
            Assertions.assertTrue((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuilder("World"), (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)"Camel", (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuffer("Camel"), (boolean)true));
            Assertions.assertFalse((boolean)org.apache.camel.support.ObjectHelper.typeCoerceContains((TypeConverter)tc, (Object)sb, (Object)new StringBuilder("Camel"), (boolean)true));
        }
    }

    @Test
    void testEqual() {
        Assertions.assertTrue((boolean)ObjectHelper.equal(null, null));
        Assertions.assertTrue((boolean)ObjectHelper.equal((Object)"", (Object)""));
        Assertions.assertTrue((boolean)ObjectHelper.equal((Object)" ", (Object)" "));
        Assertions.assertTrue((boolean)ObjectHelper.equal((Object)"Hello", (Object)"Hello"));
        Assertions.assertTrue((boolean)ObjectHelper.equal((Object)123, (Object)123));
        Assertions.assertTrue((boolean)ObjectHelper.equal((Object)true, (Object)true));
        Assertions.assertFalse((boolean)ObjectHelper.equal(null, (Object)""));
        Assertions.assertFalse((boolean)ObjectHelper.equal((Object)"", null));
        Assertions.assertFalse((boolean)ObjectHelper.equal((Object)" ", (Object)"    "));
        Assertions.assertFalse((boolean)ObjectHelper.equal((Object)"Hello", (Object)"World"));
        Assertions.assertFalse((boolean)ObjectHelper.equal((Object)true, (Object)false));
        Assertions.assertFalse((boolean)ObjectHelper.equal((Object)new Object(), (Object)new Object()));
        byte[] a = new byte[]{40, 50, 60};
        byte[] b = new byte[]{40, 50, 60};
        Assertions.assertTrue((boolean)ObjectHelper.equal((Object)a, (Object)b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{40, 50, 60, 70};
        Assertions.assertFalse((boolean)ObjectHelper.equal((Object)a, (Object)b));
    }

    @Test
    void testEqualByteArray() {
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])"Hello".getBytes(), (byte[])"Hello".getBytes()));
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])"Hello".getBytes(), (byte[])"World".getBytes()));
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])"Hello Thai Elephant \u0e08".getBytes(), (byte[])"Hello Thai Elephant \u0e08".getBytes()));
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray(null, null));
        byte[] empty = new byte[]{};
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])empty, (byte[])empty));
        byte[] a = new byte[]{40, 50, 60};
        byte[] b = new byte[]{40, 50, 60};
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{40, 50, 60, 70};
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60, 70};
        b = new byte[]{40, 50, 60};
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{};
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{};
        b = new byte[]{40, 50, 60};
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60};
        b = null;
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = null;
        b = new byte[]{40, 50, 60};
        Assertions.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = null;
        b = null;
        Assertions.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
    }

    @Test
    void testCreateIterator() {
        Iterator iterator = Collections.emptyIterator();
        Assertions.assertSame(iterator, (Object)org.apache.camel.support.ObjectHelper.createIterator(iterator), (String)"Should return the same iterator");
    }

    @Test
    void testCreateIteratorAllowEmpty() {
        String s = "a,b,,c";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)",", (boolean)true);
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertEquals((Object)"b", it.next());
        Assertions.assertEquals((Object)"", it.next());
        Assertions.assertEquals((Object)"c", it.next());
    }

    @Test
    void testCreateIteratorPattern() {
        String s = "a\nb\rc";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)"\n|\r", (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertEquals((Object)"b", it.next());
        Assertions.assertEquals((Object)"c", it.next());
    }

    @Test
    void testCreateIteratorWithStringAndCommaSeparator() {
        String s = "a,b,c";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)",");
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertEquals((Object)"b", it.next());
        Assertions.assertEquals((Object)"c", it.next());
    }

    @Test
    void testCreateIteratorWithStringAndCommaSeparatorEmptyString() {
        String s = "";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)",", (boolean)true);
        Assertions.assertEquals((Object)"", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertEquals((Object)"no more element available for '' at the index 1", (Object)nsee.getMessage());
        }
    }

    @Test
    void testCreateIteratorWithStringAndSemiColonSeparator() {
        String s = "a;b;c";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)";");
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertEquals((Object)"b", it.next());
        Assertions.assertEquals((Object)"c", it.next());
    }

    @Test
    void testCreateIteratorWithStringAndCommaInParanthesesSeparator() {
        String s = "bean:foo?method=bar('A','B','C')";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)",");
        Assertions.assertEquals((Object)"bean:foo?method=bar('A','B','C')", it.next());
    }

    @Test
    void testCreateIteratorWithStringAndCommaInParanthesesSeparatorTwo() {
        String s = "bean:foo?method=bar('A','B','C'),bean:bar?method=cool('A','Hello,World')";
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)s, (String)",");
        Assertions.assertEquals((Object)"bean:foo?method=bar('A','B','C')", it.next());
        Assertions.assertEquals((Object)"bean:bar?method=cool('A','Hello,World')", it.next());
    }

    @Test
    void testCreateIteratorWithPrimitiveArrayTypes() {
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)new byte[]{13, 127, 7, -128}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)13, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)127, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)7, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)-128, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[B@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 4"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new byte[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[B@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new short[]{13, Short.MAX_VALUE, 7, Short.MIN_VALUE}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)13, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Short.MAX_VALUE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)7, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Short.MIN_VALUE, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[S@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 4"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new short[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[S@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new int[]{13, Integer.MAX_VALUE, 7, Integer.MIN_VALUE}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)13, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Integer.MAX_VALUE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)7, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Integer.MIN_VALUE, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[I@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 4"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new int[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[I@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new long[]{13L, Long.MAX_VALUE, 7L, Long.MIN_VALUE}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)13L, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Long.MAX_VALUE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)7L, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Long.MIN_VALUE, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[J@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 4"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new long[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[J@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new float[]{13.7f, Float.MAX_VALUE, 7.13f, Float.MIN_VALUE}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Float.valueOf(13.7f), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Float.valueOf(7.13f), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[F@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 4"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new float[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[F@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new double[]{13.7, Double.MAX_VALUE, 7.13, Double.MIN_VALUE}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)13.7, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Double.MAX_VALUE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)7.13, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Double.MIN_VALUE, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[D@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 4"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new double[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[D@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new char[]{'C', 'a', 'm', 'e', 'l'}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Character.valueOf('C'), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Character.valueOf('a'), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Character.valueOf('m'), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Character.valueOf('e'), it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Character.valueOf('l'), it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[C@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 5"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new char[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[C@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new boolean[]{false, true, false, true, true}, null);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Boolean.FALSE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Boolean.TRUE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Boolean.FALSE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Boolean.TRUE, it.next());
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertEquals((Object)Boolean.TRUE, it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[Z@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 5"), (String)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)new boolean[0], null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for '[Z@"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 0"), (String)nsee.getMessage());
        }
    }

    @Test
    void testArrayAsIterator() {
        String[] data = new String[]{"a", "b"};
        Iterator iter = org.apache.camel.support.ObjectHelper.createIterator((Object)data);
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"should have next");
        Object a = iter.next();
        Assertions.assertEquals((Object)"a", a, (String)"a");
        Assertions.assertTrue((boolean)iter.hasNext(), (String)"should have next");
        Object b = iter.next();
        Assertions.assertEquals((Object)"b", b, (String)"b");
        Assertions.assertFalse((boolean)iter.hasNext(), (String)"should not have a next");
    }

    @Test
    void testIsEmpty() {
        Assertions.assertTrue((boolean)ObjectHelper.isEmpty(null));
        Assertions.assertTrue((boolean)ObjectHelper.isEmpty((String)""));
        Assertions.assertTrue((boolean)ObjectHelper.isEmpty((String)" "));
        Assertions.assertFalse((boolean)ObjectHelper.isEmpty((String)"A"));
        Assertions.assertFalse((boolean)ObjectHelper.isEmpty((String)" A"));
        Assertions.assertFalse((boolean)ObjectHelper.isEmpty((String)" A "));
        Assertions.assertFalse((boolean)ObjectHelper.isEmpty((Object)new Object()));
    }

    @Test
    void testIsNotEmpty() {
        Assertions.assertFalse((boolean)ObjectHelper.isNotEmpty(null));
        Assertions.assertFalse((boolean)ObjectHelper.isNotEmpty((String)""));
        Assertions.assertFalse((boolean)ObjectHelper.isNotEmpty((String)" "));
        Assertions.assertTrue((boolean)ObjectHelper.isNotEmpty((String)"A"));
        Assertions.assertTrue((boolean)ObjectHelper.isNotEmpty((String)" A"));
        Assertions.assertTrue((boolean)ObjectHelper.isNotEmpty((String)" A "));
        Assertions.assertTrue((boolean)ObjectHelper.isNotEmpty((Object)new Object()));
    }

    @Test
    void testIteratorWithComma() {
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)"Claus,Jonathan");
        Assertions.assertEquals((Object)"Claus", it.next());
        Assertions.assertEquals((Object)"Jonathan", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void testIteratorWithOtherDelimiter() {
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)"Claus#Jonathan", (String)"#");
        Assertions.assertEquals((Object)"Claus", it.next());
        Assertions.assertEquals((Object)"Jonathan", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
    }

    @Test
    void testIteratorEmpty() {
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)"");
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertEquals((Object)"no more element available for '' at the index 0", (Object)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator((Object)"    ");
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertEquals((Object)"no more element available for '    ' at the index 0", (Object)nsee.getMessage());
        }
        it = org.apache.camel.support.ObjectHelper.createIterator(null);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    void testIteratorIdempotentNext() {
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)"a");
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasNext());
        it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertEquals((Object)"no more element available for 'a' at the index 1", (Object)nsee.getMessage());
        }
    }

    @Test
    void testIteratorIdempotentNextWithNodeList() {
        NodeList nodeList = new NodeList(){

            @Override
            public Node item(int index) {
                return null;
            }

            @Override
            public int getLength() {
                return 1;
            }
        };
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)nodeList);
        Assertions.assertTrue((boolean)it.hasNext());
        Assertions.assertTrue((boolean)it.hasNext());
        it.next();
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertTrue((boolean)nsee.getMessage().startsWith("no more element available for 'org.apache.camel.util.ObjectHelperTest$"), (String)nsee.getMessage());
            Assertions.assertTrue((boolean)nsee.getMessage().endsWith("at the index 1"), (String)nsee.getMessage());
        }
    }

    @Test
    void testGetCamelContextPropertiesWithPrefix() {
        DefaultCamelContext context = new DefaultCamelContext();
        Map properties = context.getGlobalOptions();
        properties.put("camel.object.helper.test1", "test1");
        properties.put("camel.object.helper.test2", "test2");
        properties.put("camel.object.test", "test");
        Properties result = CamelContextHelper.getCamelPropertiesWithPrefix((String)"camel.object.helper.", (CamelContext)context);
        Assertions.assertEquals((int)2, (int)result.size(), (String)"Get a wrong size properties");
        Assertions.assertEquals((Object)"test1", (Object)result.get("test1"), (String)"It should contain the test1");
        Assertions.assertEquals((Object)"test2", (Object)result.get("test2"), (String)"It should contain the test2");
    }

    @Test
    void testEvaluateAsPredicate() {
        Assertions.assertFalse((boolean)ObjectHelper.evaluateValuePredicate(null));
        Assertions.assertTrue((boolean)ObjectHelper.evaluateValuePredicate((Object)123));
        Assertions.assertTrue((boolean)ObjectHelper.evaluateValuePredicate((Object)"true"));
        Assertions.assertTrue((boolean)ObjectHelper.evaluateValuePredicate((Object)"TRUE"));
        Assertions.assertFalse((boolean)ObjectHelper.evaluateValuePredicate((Object)"false"));
        Assertions.assertFalse((boolean)ObjectHelper.evaluateValuePredicate((Object)"FALSE"));
        Assertions.assertTrue((boolean)ObjectHelper.evaluateValuePredicate((Object)"foobar"));
        Assertions.assertFalse((boolean)ObjectHelper.evaluateValuePredicate((Object)""));
        Assertions.assertFalse((boolean)ObjectHelper.evaluateValuePredicate((Object)" "));
        ArrayList<String> list = new ArrayList<String>();
        Assertions.assertFalse((boolean)ObjectHelper.evaluateValuePredicate(list));
        list.add("foo");
        Assertions.assertTrue((boolean)ObjectHelper.evaluateValuePredicate(list));
    }

    @Test
    void testIsPrimitiveArrayType() {
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(byte[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(short[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(int[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(long[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(float[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(double[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(char[].class));
        Assertions.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(boolean[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Object[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Byte[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Short[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Integer[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Long[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Float[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Double[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Character[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Boolean[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Void[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(CamelContext[].class));
        Assertions.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(null));
    }

    @Test
    void testGetDefaultCharSet() {
        Assertions.assertNotNull((Object)ObjectHelper.getDefaultCharacterSet());
    }

    @Test
    void testConvertPrimitiveTypeToWrapper() {
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Integer.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Long", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Long.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Double", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Double.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Float", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Float.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Short", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Short.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Byte", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Byte.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Boolean", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Boolean.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Character", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Character.TYPE).getName());
        Assertions.assertEquals((Object)"java.lang.Object", (Object)ObjectHelper.convertPrimitiveTypeToWrapperType(Object.class).getName());
    }

    @Test
    void testAsString() {
        Object[] args = new String[]{"foo", "bar"};
        String out = ObjectHelper.asString((Object[])args);
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)"{foo, bar}", (Object)out);
    }

    @Test
    void testName() {
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)ObjectHelper.name(Integer.class));
        Assertions.assertNull((Object)ObjectHelper.name(null));
    }

    @Test
    void testClassName() {
        Assertions.assertEquals((Object)"java.lang.Integer", (Object)ObjectHelper.className((Object)Integer.valueOf("5")));
        Assertions.assertNull((Object)ObjectHelper.className(null));
    }

    @Test
    void testGetSystemPropertyDefault() {
        Assertions.assertEquals((Object)"foo", (Object)ObjectHelper.getSystemProperty((String)"CamelFooDoesNotExist", (String)"foo"));
    }

    @Test
    void testGetSystemPropertyBooleanDefault() {
        Assertions.assertTrue((boolean)ObjectHelper.getSystemProperty((String)"CamelFooDoesNotExist", (Boolean)Boolean.TRUE));
    }

    @Test
    void testMatches() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add("foo");
        data.add("bar");
        Assertions.assertTrue((boolean)ObjectHelper.matches(data));
        data.clear();
        data.add(Boolean.FALSE);
        data.add("bar");
        Assertions.assertFalse((boolean)ObjectHelper.matches(data));
        data.clear();
        Assertions.assertFalse((boolean)ObjectHelper.matches(data));
    }

    @Test
    void testToBoolean() {
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ObjectHelper.toBoolean((Object)Boolean.TRUE));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ObjectHelper.toBoolean((Object)"true"));
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)ObjectHelper.toBoolean((Object)Integer.valueOf("1")));
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)ObjectHelper.toBoolean((Object)Integer.valueOf("0")));
        Assertions.assertNull((Object)ObjectHelper.toBoolean((Object)new Date()));
    }

    @Test
    void testIteratorWithMessage() {
        DefaultMessage msg = new DefaultMessage((CamelContext)new DefaultCamelContext());
        msg.setBody((Object)"a,b,c");
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)msg);
        Assertions.assertEquals((Object)"a", it.next());
        Assertions.assertEquals((Object)"b", it.next());
        Assertions.assertEquals((Object)"c", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    void testIteratorWithEmptyMessage() {
        DefaultMessage msg = new DefaultMessage((CamelContext)new DefaultCamelContext());
        msg.setBody((Object)"");
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)msg);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            Assertions.assertEquals((Object)"no more element available for '' at the index 0", (Object)nsee.getMessage());
        }
    }

    @Test
    void testIteratorWithNullMessage() {
        DefaultMessage msg = new DefaultMessage((CamelContext)new DefaultCamelContext());
        msg.setBody(null);
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)msg);
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    void testIterable() {
        final ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        Iterable<String> itb = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return data.iterator();
            }
        };
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)itb);
        Assertions.assertEquals((Object)"A", it.next());
        Assertions.assertEquals((Object)"B", it.next());
        Assertions.assertEquals((Object)"C", it.next());
        Assertions.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    void testLookupConstantFieldValue() {
        Assertions.assertEquals((Object)"CamelFileName", (Object)ObjectHelper.lookupConstantFieldValue(Exchange.class, (String)"FILE_NAME"));
        Assertions.assertNull((Object)ObjectHelper.lookupConstantFieldValue(Exchange.class, (String)"XXX"));
        Assertions.assertNull((Object)ObjectHelper.lookupConstantFieldValue(null, (String)"FILE_NAME"));
    }

    @Test
    void testHasDefaultPublicNoArgConstructor() {
        Assertions.assertTrue((boolean)ObjectHelper.hasDefaultPublicNoArgConstructor(ObjectHelperTest.class));
        Assertions.assertFalse((boolean)ObjectHelper.hasDefaultPublicNoArgConstructor(MyStaticClass.class));
    }

    @Test
    void testIdentityHashCode() {
        MyDummyObject dummy = new MyDummyObject("Camel");
        String code = ObjectHelper.getIdentityHashCode((Object)dummy);
        String code2 = ObjectHelper.getIdentityHashCode((Object)dummy);
        Assertions.assertEquals((Object)code, (Object)code2);
        MyDummyObject dummyB = new MyDummyObject("Camel");
        String code3 = ObjectHelper.getIdentityHashCode((Object)dummyB);
        Assertions.assertNotSame((Object)code, (Object)code3);
    }

    @Test
    void testIsNaN() {
        Assertions.assertTrue((boolean)ObjectHelper.isNaN((Object)Float.valueOf(Float.NaN)));
        Assertions.assertTrue((boolean)ObjectHelper.isNaN((Object)Double.NaN));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN(null));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)""));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)"1.0"));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)1));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)Float.valueOf(1.5f)));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)1.5));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)false));
        Assertions.assertFalse((boolean)ObjectHelper.isNaN((Object)true));
    }

    @Test
    void testNotNull() {
        Long expected = 3L;
        Long actual = (Long)ObjectHelper.notNull((Object)expected, (String)"expected");
        Assertions.assertSame((Object)expected, (Object)actual, (String)"Didn't get the same object back!");
        Long actual2 = (Long)ObjectHelper.notNull((Object)expected, (String)"expected", (Object)"holder");
        Assertions.assertSame((Object)expected, (Object)actual2, (String)"Didn't get the same object back!");
        Object expected2 = null;
        try {
            ObjectHelper.notNull(expected2, (String)"expected2");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException iae) {
            Assertions.assertEquals((Object)"expected2 must be specified", (Object)iae.getMessage());
        }
        try {
            ObjectHelper.notNull(expected2, (String)"expected2", (Object)"holder");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException iae) {
            Assertions.assertEquals((Object)"expected2 must be specified on: holder", (Object)iae.getMessage());
        }
    }

    @Test
    void testSameMethodIsOverride() throws Exception {
        Method m = MyOtherFooBean.class.getMethod("toString", Object.class);
        Assertions.assertTrue((boolean)ObjectHelper.isOverridingMethod((Method)m, (Method)m, (boolean)false));
    }

    @Test
    void testOverloadIsNotOverride() throws Exception {
        Method m1 = MyOtherFooBean.class.getMethod("toString", Object.class);
        Method m2 = MyOtherFooBean.class.getMethod("toString", String.class);
        Assertions.assertFalse((boolean)ObjectHelper.isOverridingMethod((Method)m2, (Method)m1, (boolean)false));
    }

    @Test
    void testOverrideEquivalentSignatureFromSiblingClassIsNotOverride() throws Exception {
        Method m1 = Double.class.getMethod("intValue", new Class[0]);
        Method m2 = Float.class.getMethod("intValue", new Class[0]);
        Assertions.assertFalse((boolean)ObjectHelper.isOverridingMethod((Method)m2, (Method)m1, (boolean)false));
    }

    @Test
    void testOverrideEquivalentSignatureFromUpperClassIsOverride() throws Exception {
        Method m1 = Double.class.getMethod("intValue", new Class[0]);
        Method m2 = Number.class.getMethod("intValue", new Class[0]);
        Assertions.assertTrue((boolean)ObjectHelper.isOverridingMethod((Method)m2, (Method)m1, (boolean)false));
    }

    @Test
    void testInheritedMethodCanOverrideInterfaceMethod() throws Exception {
        Method m1 = MyOtherFooBean.AbstractClassSize.class.getMethod("size", new Class[0]);
        Method m2 = MyOtherFooBean.InterfaceSize.class.getMethod("size", new Class[0]);
        Assertions.assertTrue((boolean)ObjectHelper.isOverridingMethod(MyOtherFooBean.Clazz.class, (Method)m2, (Method)m1, (boolean)false));
    }

    @Test
    void testNonInheritedMethodCantOverrideInterfaceMethod() throws Exception {
        Method m1 = MyOtherFooBean.AbstractClassSize.class.getMethod("size", new Class[0]);
        Method m2 = MyOtherFooBean.InterfaceSize.class.getMethod("size", new Class[0]);
        Assertions.assertFalse((boolean)ObjectHelper.isOverridingMethod(MyOtherFooBean.InterfaceSize.class, (Method)m2, (Method)m1, (boolean)false));
    }

    @Test
    void testAsList() {
        List out0 = ObjectHelper.asList(null);
        Assertions.assertNotNull((Object)out0);
        boolean b2 = out0.isEmpty();
        Assertions.assertTrue((boolean)b2);
        List out1 = ObjectHelper.asList((Object[])new Object[0]);
        Assertions.assertNotNull((Object)out1);
        boolean b1 = out1.isEmpty();
        Assertions.assertTrue((boolean)b1);
        Object[] args = new String[]{"foo", "bar"};
        List out2 = ObjectHelper.asList((Object[])args);
        Assertions.assertNotNull((Object)out2);
        boolean b = out2.size() == 2;
        Assertions.assertTrue((boolean)b);
        Assertions.assertEquals((Object)"foo", out2.get(0));
        Assertions.assertEquals((Object)"bar", out2.get(1));
    }

    @Test
    void testIterableWithNullContent() {
        Assertions.assertEquals((Object)"", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable(null, (String)";;").spliterator(), false).collect(Collectors.joining("-")));
    }

    @Test
    void testIterableWithEmptyContent() {
        Assertions.assertEquals((Object)"", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable((String)"", (String)";;").spliterator(), false).collect(Collectors.joining("-")));
    }

    @Test
    void testIterableWithOneElement() {
        Assertions.assertEquals((Object)"foo", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable((String)"foo", (String)";;").spliterator(), false).collect(Collectors.joining("-")));
    }

    @ParameterizedTest
    @ValueSource(strings={"foo;;bar", ";;foo;;bar", "foo;;bar;;", ";;foo;;bar;;"})
    void testIterableWithTwoElements(String content) {
        Assertions.assertEquals((Object)"foo-bar", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable((String)content, (String)";;").spliterator(), false).collect(Collectors.joining("-")));
    }

    @Test
    void testIterableUsingPatternWithNullContent() {
        Assertions.assertEquals((Object)"", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable(null, (String)";+", (boolean)false, (boolean)true).spliterator(), false).collect(Collectors.joining("-")));
    }

    @Test
    void testIterableUsingPatternWithEmptyContent() {
        Assertions.assertEquals((Object)"", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable((String)"", (String)";+", (boolean)false, (boolean)true).spliterator(), false).collect(Collectors.joining("-")));
    }

    @Test
    void testIterableUsingPatternWithOneElement() {
        Assertions.assertEquals((Object)"foo", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable((String)"foo", (String)";+", (boolean)false, (boolean)true).spliterator(), false).collect(Collectors.joining("-")));
    }

    @ParameterizedTest
    @ValueSource(strings={"foo;;bar", ";;foo;;bar", "foo;;bar;;", ";;foo;;bar;;"})
    void testIterableUsingPatternWithTwoElements(String content) {
        Assertions.assertEquals((Object)"foo-bar", (Object)StreamSupport.stream(org.apache.camel.support.ObjectHelper.createIterable((String)content, (String)";+", (boolean)false, (boolean)true).spliterator(), false).collect(Collectors.joining("-")));
    }

    @Test
    public void testAddListByIndex() {
        ArrayList list = new ArrayList();
        ObjectHelper.addListByIndex(list, (int)0, (Object)"aaa");
        ObjectHelper.addListByIndex(list, (int)2, (Object)"ccc");
        ObjectHelper.addListByIndex(list, (int)1, (Object)"bbb");
        Assertions.assertEquals((int)3, (int)list.size());
        Assertions.assertEquals((Object)"aaa", list.get(0));
        Assertions.assertEquals((Object)"bbb", list.get(1));
        Assertions.assertEquals((Object)"ccc", list.get(2));
        ObjectHelper.addListByIndex(list, (int)99, (Object)"zzz");
        Assertions.assertEquals((int)100, (int)list.size());
        Assertions.assertNull(list.get(4));
        Assertions.assertNull(list.get(50));
        Assertions.assertNull(list.get(98));
        Assertions.assertEquals((Object)"zzz", list.get(99));
    }

    @Test
    public void testIsNumeric() {
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Integer.TYPE));
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Integer.class));
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Long.TYPE));
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Long.class));
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Double.class));
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Float.TYPE));
        Assertions.assertTrue((boolean)ObjectHelper.isNumericType(Byte.TYPE));
        Assertions.assertFalse((boolean)ObjectHelper.isNumericType(String.class));
        Assertions.assertFalse((boolean)ObjectHelper.isNumericType(Node.class));
    }
}

