/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.DefaultHeaderFilterStrategy;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.MessageHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageHelperTest {
    private Message message;
    private final CamelContext camelContext = new DefaultCamelContext();

    @BeforeEach
    public void setUp() {
        this.message = new DefaultMessage(this.camelContext);
    }

    @Test
    public void testResetStreamCache() {
        MessageHelper.resetStreamCache(null);
        MessageHelper.resetStreamCache((Message)this.message);
        final AtomicBoolean reset = new AtomicBoolean();
        this.message.setBody((Object)new StreamCache(){

            public void reset() {
                reset.set(true);
            }

            public void writeTo(OutputStream os) {
            }

            public StreamCache copy(Exchange exchange) {
                return null;
            }

            public boolean inMemory() {
                return true;
            }

            public long length() {
                return 0L;
            }

            public long position() {
                return 0L;
            }
        });
        MessageHelper.resetStreamCache((Message)this.message);
        Assertions.assertTrue((boolean)reset.get(), (String)"Should have reset the stream cache");
    }

    @Test
    public void testGetContentType() {
        this.message.setHeader("Content-Type", (Object)"text/xml");
        Assertions.assertEquals((Object)"text/xml", (Object)MessageHelper.getContentType((Message)this.message));
    }

    @Test
    public void testGetContentEncpding() {
        this.message.setHeader("Content-Encoding", (Object)"iso-8859-1");
        Assertions.assertEquals((Object)"iso-8859-1", (Object)MessageHelper.getContentEncoding((Message)this.message));
    }

    @Test
    public void testCopyHeaders() {
        Message source = this.message;
        DefaultMessage target = new DefaultMessage(this.camelContext);
        source.setHeader("foo", (Object)123);
        source.setHeader("bar", (Object)456);
        target.setHeader("bar", (Object)"yes");
        MessageHelper.copyHeaders((Message)source, (Message)target, (boolean)false);
        Assertions.assertEquals((Object)123, (Object)target.getHeader("foo"));
        Assertions.assertEquals((Object)"yes", (Object)target.getHeader("bar"));
    }

    @Test
    public void testCopyHeadersOverride() {
        Message source = this.message;
        DefaultMessage target = new DefaultMessage(this.camelContext);
        source.setHeader("foo", (Object)123);
        source.setHeader("bar", (Object)456);
        target.setHeader("bar", (Object)"yes");
        MessageHelper.copyHeaders((Message)source, (Message)target, (boolean)true);
        Assertions.assertEquals((Object)123, (Object)target.getHeader("foo"));
        Assertions.assertEquals((Object)456, (Object)target.getHeader("bar"));
    }

    @Test
    public void testCopyHeadersWithHeaderFilterStrategy() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        Message source = this.message = new DefaultExchange((CamelContext)context).getIn();
        Message target = this.message.getExchange().getOut();
        DefaultHeaderFilterStrategy headerFilterStrategy = new DefaultHeaderFilterStrategy();
        headerFilterStrategy.setInFilterPattern("foo");
        source.setHeader("foo", (Object)123);
        source.setHeader("bar", (Object)456);
        target.setHeader("bar", (Object)"yes");
        MessageHelper.copyHeaders((Message)source, (Message)target, (HeaderFilterStrategy)headerFilterStrategy, (boolean)true);
        Assertions.assertNull((Object)target.getHeader("foo"));
        Assertions.assertEquals((Object)456, (Object)target.getHeader("bar"));
        context.stop();
    }

    @Test
    public void testDumpAsXmlPlainBody() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message);
        Assertions.assertTrue((boolean)out.contains("<body type=\"java.lang.String\">Hello World</body>"), (String)"Should contain body");
        context.stop();
    }

    @Test
    public void testDumpAsXmlBody() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"<?xml version=\"1.0\"?><hi>Hello World</hi>");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message);
        Assertions.assertTrue((boolean)out.contains("<body type=\"java.lang.String\">&lt;?xml version=&quot;1.0&quot;?&gt;&lt;hi&gt;Hello World&lt;/hi&gt;</body>"), (String)"Should contain body");
        Assertions.assertTrue((boolean)out.contains(this.message.getExchange().getExchangeId()), (String)"Should contain exchangeId");
        context.stop();
    }

    @Test
    public void testDumpAsXmlNoBody() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message, (boolean)false);
        Assertions.assertEquals((Object)("<message exchangeId=\"" + this.message.getExchange().getExchangeId() + "\" exchangePattern=\"InOnly\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n  <headers>\n    <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n  </headers>\n</message>"), (Object)out);
        context.stop();
    }

    @Test
    public void testDumpAsXmlNoBodyIndent() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context, ExchangePattern.InOut).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message, (boolean)false, (int)2);
        Assertions.assertEquals((Object)("  <message exchangeId=\"" + this.message.getExchange().getExchangeId() + "\" exchangePattern=\"InOut\" exchangeType=\"org.apache.camel.support.DefaultExchange\" messageType=\"org.apache.camel.support.DefaultMessage\">\n    <headers>\n      <header key=\"foo\" type=\"java.lang.Integer\">123</header>\n    </headers>\n  </message>"), (Object)out);
        context.stop();
    }

    @Test
    public void testMessageDumpBody() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsXml((Message)this.message, (boolean)true);
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.contains("Hello World"));
    }

    @Test
    public void testMessageDumpBodyJSon() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsJSon((Message)this.message, (boolean)true);
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.contains("Hello World"));
    }

    @Test
    public void testDumpAsXmlBodyJSon() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"<?xml version=\"1.0\"?><hi>Hello World</hi>");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsJSon((Message)this.message);
        Assertions.assertTrue((boolean)out.contains(this.message.getExchange().getExchangeId()), (String)"Should contain exchangeId");
        context.stop();
    }

    @Test
    public void testMessageDumpBodyIndentJSon() {
        DefaultCamelContext context = new DefaultCamelContext();
        context.start();
        this.message = new DefaultExchange((CamelContext)context).getIn();
        this.message.setBody((Object)"Hello World");
        this.message.setHeader("foo", (Object)123);
        String out = MessageHelper.dumpAsJSon((Message)this.message, (boolean)true, (int)4);
        Assertions.assertNotNull((Object)out);
        Assertions.assertTrue((boolean)out.contains("Hello World"));
    }
}

