/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.KeyValueHolder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KeyValueHolderTest {
    @Test
    public void testKeyValueHolder() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        Assertions.assertEquals((Object)"foo", (Object)foo.getKey());
        Assertions.assertEquals((int)123, (int)((Integer)foo.getValue()));
    }

    @Test
    public void testEqualsAndHashCodeOnEqualObjects() {
        KeyValueHolder foo1 = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder foo2 = new KeyValueHolder((Object)"foo", (Object)123);
        Assertions.assertEquals((Object)foo2, (Object)foo1, (String)"Should be equals");
        Assertions.assertEquals((int)foo2.hashCode(), (int)foo1.hashCode(), (String)"Hash code should be equal");
    }

    @Test
    public void testEqualsAndHashCodeOnUnequalObjects() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder bar = new KeyValueHolder((Object)"bar", (Object)678);
        Assertions.assertNotEquals((Object)bar, (Object)foo, (String)"Should not be equals");
        Assertions.assertNotEquals((int)bar.hashCode(), (int)foo.hashCode(), (String)"Hash code should not be equal");
    }

    @Test
    public void testEqualsAndHashCodeOnUnequalObjectsWithSameKeys() {
        KeyValueHolder foo1 = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder foo2 = new KeyValueHolder((Object)"foo", (Object)678);
        Assertions.assertNotEquals((Object)foo2, (Object)foo1, (String)"Should not be equals");
        Assertions.assertNotEquals((int)foo2.hashCode(), (int)foo1.hashCode(), (String)"Hash code should not be equal");
    }

    @Test
    public void testEqualsAndHashCodeOnUnequalObjectsWithSameValues() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        KeyValueHolder bar = new KeyValueHolder((Object)"bar", (Object)123);
        Assertions.assertNotEquals((Object)bar, (Object)foo, (String)"Should not be equals");
        Assertions.assertNotEquals((int)bar.hashCode(), (int)foo.hashCode(), (String)"Hash code should not be equal");
    }

    @Test
    public void testToString() {
        KeyValueHolder foo = new KeyValueHolder((Object)"foo", (Object)123);
        Assertions.assertEquals((Object)"foo -> 123", (Object)foo.toString());
    }
}

