/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOHelperTest {
    @Test
    public void testIOException() {
        IOException io = new IOException("Damn", new IllegalArgumentException("Damn"));
        Assertions.assertEquals((Object)"Damn", (Object)io.getMessage());
        Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)io.getCause());
    }

    @Test
    public void testIOExceptionWithMessage() {
        IOException io = new IOException("Not again", new IllegalArgumentException("Damn"));
        Assertions.assertEquals((Object)"Not again", (Object)io.getMessage());
        Assertions.assertInstanceOf(IllegalArgumentException.class, (Object)io.getCause());
    }

    @Test
    public void testCopyAndCloseInput() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("Hello".getBytes());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os, (int)256);
    }

    @Test
    public void testCharsetNormalize() {
        Assertions.assertEquals((Object)"UTF-8", (Object)IOHelper.normalizeCharset((String)"'UTF-8'"));
        Assertions.assertEquals((Object)"UTF-8", (Object)IOHelper.normalizeCharset((String)"\"UTF-8\""));
        Assertions.assertEquals((Object)"UTF-8", (Object)IOHelper.normalizeCharset((String)"\"UTF-8 \""));
        Assertions.assertEquals((Object)"UTF-8", (Object)IOHelper.normalizeCharset((String)"' UTF-8'"));
    }

    @Test
    public void testLine1() throws Exception {
        this.assertReadAsWritten("line1", "line1", "line1\n");
    }

    @Test
    public void testLine1LF() throws Exception {
        this.assertReadAsWritten("line1LF", "line1\n", "line1\n");
    }

    @Test
    public void testLine2() throws Exception {
        this.assertReadAsWritten("line2", "line1\nline2", "line1\nline2\n");
    }

    @Test
    public void testLine2LF() throws Exception {
        this.assertReadAsWritten("line2LF", "line1\nline2\n", "line1\nline2\n");
    }

    private void assertReadAsWritten(String testname, String text, String compareText) throws Exception {
        File file = this.tempFile(testname);
        this.write(file, text);
        String loadText = IOHelper.loadText((InputStream)Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]));
        Assertions.assertEquals((Object)compareText, (Object)loadText);
    }

    private File tempFile(String testname) throws Exception {
        return File.createTempFile(testname, "");
    }

    private void write(File file, String text) throws Exception {
        PrintWriter out = new PrintWriter(file);
        out.print(text);
        out.close();
    }

    @Test
    public void testCharsetName() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        Assertions.assertNull((Object)ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)false));
        exchange.getIn().setHeader("CamelCharsetName", (Object)"iso-8859-1");
        Assertions.assertEquals((Object)"iso-8859-1", (Object)ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)false));
        exchange.getIn().removeHeader("CamelCharsetName");
        exchange.setProperty("CamelCharsetName", (Object)"iso-8859-1");
        Assertions.assertEquals((Object)"iso-8859-1", (Object)ExchangeHelper.getCharsetName((Exchange)exchange, (boolean)false));
    }

    @Test
    public void testGetCharsetNameFromContentType() {
        String charsetName = IOHelper.getCharsetNameFromContentType((String)"text/html; charset=iso-8859-1");
        Assertions.assertEquals((Object)"iso-8859-1", (Object)charsetName);
        charsetName = IOHelper.getCharsetNameFromContentType((String)"text/html");
        Assertions.assertEquals((Object)"UTF-8", (Object)charsetName);
    }

    @Test
    public void testCharset() {
        DefaultExchange exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        Assertions.assertNull((Object)ExchangeHelper.getCharset((Exchange)exchange, (boolean)false));
        exchange.getIn().setHeader("CamelCharsetName", (Object)"iso-8859-1");
        Charset cs = ExchangeHelper.getCharset((Exchange)exchange, (boolean)false);
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)cs.name());
        exchange.getIn().removeHeader("CamelCharsetName");
        exchange.setProperty("CamelCharsetName", (Object)"iso-8859-1");
        cs = ExchangeHelper.getCharset((Exchange)exchange, (boolean)false);
        Assertions.assertEquals((Object)"ISO-8859-1", (Object)cs.name());
    }
}

