/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IOHelperCharsetTest
extends ContextTestSupport {
    private static final String CONTENT = "G\u00f6tzend\u00e4mmerung,Joseph und seine Br\u00fcder";

    @Test
    public void testToInputStreamFileWithCharsetUTF8() throws Exception {
        IOHelperCharsetTest.switchToDefaultCharset(StandardCharsets.UTF_8);
        File file = new File("src/test/resources/org/apache/camel/converter/german.utf-8.txt");
        try (InputStream in = IOHelper.toInputStream((File)file, (String)"UTF-8");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
             BufferedReader naiveReader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            Assertions.assertEquals((Object)naiveLine, (Object)line);
            Assertions.assertEquals((Object)CONTENT, (Object)line);
        }
    }

    @Test
    public void testToInputStreamFileWithCharsetUTF8withOtherDefaultEncoding() throws Exception {
        IOHelperCharsetTest.switchToDefaultCharset(StandardCharsets.ISO_8859_1);
        File file = new File("src/test/resources/org/apache/camel/converter/german.utf-8.txt");
        try (InputStream in = IOHelper.toInputStream((File)file, (String)"UTF-8");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.ISO_8859_1));
             BufferedReader naiveReader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            Assertions.assertEquals((Object)naiveLine, (Object)line);
            Assertions.assertEquals((Object)CONTENT, (Object)line);
        }
    }

    @Test
    public void testToInputStreamFileWithCharsetLatin1() throws Exception {
        IOHelperCharsetTest.switchToDefaultCharset(StandardCharsets.UTF_8);
        File file = new File("src/test/resources/org/apache/camel/converter/german.iso-8859-1.txt");
        try (InputStream in = IOHelper.toInputStream((File)file, (String)"ISO-8859-1");
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
             BufferedReader naiveReader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]), StandardCharsets.ISO_8859_1));){
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            Assertions.assertEquals((Object)naiveLine, (Object)line);
            Assertions.assertEquals((Object)CONTENT, (Object)line);
        }
    }

    @Test
    public void testToInputStreamFileDirectByteDumpWithCharsetLatin1() throws Exception {
        IOHelperCharsetTest.switchToDefaultCharset(StandardCharsets.UTF_8);
        File file = new File("src/test/resources/org/apache/camel/converter/german.iso-8859-1.txt");
        try (InputStream in = IOHelper.toInputStream((File)file, (String)"ISO-8859-1");
             InputStream naiveIn = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);){
            byte[] bytes = new byte[8192];
            in.read(bytes);
            byte[] naiveBytes = new byte[8192];
            naiveIn.read(naiveBytes);
            Assertions.assertFalse((boolean)Arrays.equals(naiveBytes, bytes), (String)"both input streams deliver the same byte sequence");
        }
    }

    @Test
    public void testToReaderFileWithCharsetUTF8() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/converter/german.utf-8.txt");
        try (BufferedReader reader = IOHelper.toReader((File)file, (String)"UTF-8");
             BufferedReader naiveReader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            Assertions.assertEquals((Object)naiveLine, (Object)line);
            Assertions.assertEquals((Object)CONTENT, (Object)line);
        }
    }

    @Test
    public void testToReaderFileWithCharsetLatin1() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/converter/german.iso-8859-1.txt");
        try (BufferedReader reader = IOHelper.toReader((File)file, (String)"ISO-8859-1");
             BufferedReader naiveReader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]), StandardCharsets.ISO_8859_1));){
            String line = reader.readLine();
            String naiveLine = naiveReader.readLine();
            Assertions.assertEquals((Object)naiveLine, (Object)line);
            Assertions.assertEquals((Object)CONTENT, (Object)line);
        }
    }

    private static void switchToDefaultCharset(Charset charset) {
        IOHelper.defaultCharset = () -> charset;
    }
}

