/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.CamelContext;
import org.apache.camel.Message;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultMessage;
import org.apache.camel.support.GZIPHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GZIPHelperTest {
    private static final byte[] sampleBytes = new byte[]{1, 2, 3, 1, 2, 3};

    @Test
    public void toGZIPInputStreamShouldReturnTheSameInputStream() throws IOException {
        InputStream inputStream = GZIPHelper.uncompressGzip((String)"text", (InputStream)new ByteArrayInputStream(sampleBytes));
        byte[] bytes = new byte[6];
        inputStream.read(bytes);
        Assertions.assertEquals((int)-1, (int)inputStream.read());
        Assertions.assertArrayEquals((byte[])sampleBytes, (byte[])bytes);
    }

    @Test
    public void toGZIPInputStreamShouldReturnAByteArrayInputStream() throws IOException {
        InputStream inputStream = GZIPHelper.compressGzip((String)"text", (byte[])sampleBytes);
        byte[] bytes = IOConverter.toBytes((InputStream)inputStream);
        Assertions.assertArrayEquals((byte[])sampleBytes, (byte[])bytes);
    }

    @Test
    public void testCompressAndUnCompressData() throws IOException {
        String sampleString = "<Hello>World</Hello>";
        InputStream inputStream = GZIPHelper.compressGzip((String)"gzip", (InputStream)new ByteArrayInputStream(sampleString.getBytes()));
        Assertions.assertNotNull((Object)inputStream, (String)"The inputStream should not be null.");
        inputStream = GZIPHelper.uncompressGzip((String)"gzip", (InputStream)inputStream);
        String result = IOConverter.toString((InputStream)inputStream, null);
        Assertions.assertEquals((Object)sampleString, (Object)result, (String)"The result is wrong.");
    }

    @Test
    public void testIsGzipMessage() {
        Assertions.assertTrue((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader("gzip")));
        Assertions.assertTrue((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader("GZip")));
        Assertions.assertFalse((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader(null)));
        Assertions.assertFalse((boolean)GZIPHelper.isGzip((Message)this.createMessageWithContentEncodingHeader("zip")));
    }

    @Test
    public void isGzipString() {
        Assertions.assertTrue((boolean)GZIPHelper.isGzip((String)"gzip"));
        Assertions.assertTrue((boolean)GZIPHelper.isGzip((String)"GZip"));
        Assertions.assertFalse((boolean)GZIPHelper.isGzip((String)null));
        Assertions.assertFalse((boolean)GZIPHelper.isGzip((String)"zip"));
    }

    private Message createMessageWithContentEncodingHeader(String contentEncoding) {
        DefaultMessage msg = new DefaultMessage((CamelContext)new DefaultCamelContext());
        msg.setHeader("Content-Encoding", (Object)contentEncoding);
        return msg;
    }
}

