/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.camel.TestSupport;
import org.apache.camel.util.FileUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileUtilTest
extends TestSupport {
    @Test
    public void testNormalizePath() {
        if (FileUtil.isWindows()) {
            Assertions.assertEquals((Object)"foo\\bar", (Object)FileUtil.normalizePath((String)"foo/bar"));
            Assertions.assertEquals((Object)"foo\\bar\\baz", (Object)FileUtil.normalizePath((String)"foo/bar\\baz"));
            Assertions.assertEquals((Object)"movefile\\sub\\sub2\\.done\\goodday.txt", (Object)FileUtil.normalizePath((String)"movefile/sub/sub2\\.done\\goodday.txt"));
        } else {
            Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.normalizePath((String)"foo/bar"));
            Assertions.assertEquals((Object)"foo/bar/baz", (Object)FileUtil.normalizePath((String)"foo/bar\\baz"));
            Assertions.assertEquals((Object)"movefile/sub/sub2/.done/goodday.txt", (Object)FileUtil.normalizePath((String)"movefile/sub/sub2\\.done\\goodday.txt"));
        }
    }

    @Test
    public void testStripLeadingSeparator() {
        Assertions.assertNull((Object)FileUtil.stripLeadingSeparator(null));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripLeadingSeparator((String)"foo"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripLeadingSeparator((String)"foo/bar"));
        Assertions.assertEquals((Object)"foo/", (Object)FileUtil.stripLeadingSeparator((String)"foo/"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripLeadingSeparator((String)"/foo/bar"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripLeadingSeparator((String)"//foo/bar"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripLeadingSeparator((String)"///foo/bar"));
    }

    @Test
    public void testHasLeadingSeparator() {
        Assertions.assertFalse((boolean)FileUtil.hasLeadingSeparator(null));
        Assertions.assertFalse((boolean)FileUtil.hasLeadingSeparator((String)"foo"));
        Assertions.assertFalse((boolean)FileUtil.hasLeadingSeparator((String)"foo/bar"));
        Assertions.assertFalse((boolean)FileUtil.hasLeadingSeparator((String)"foo/"));
        Assertions.assertTrue((boolean)FileUtil.hasLeadingSeparator((String)"/foo/bar"));
        Assertions.assertTrue((boolean)FileUtil.hasLeadingSeparator((String)"//foo/bar"));
        Assertions.assertTrue((boolean)FileUtil.hasLeadingSeparator((String)"///foo/bar"));
    }

    @Test
    public void testStripFirstLeadingSeparator() {
        Assertions.assertNull((Object)FileUtil.stripFirstLeadingSeparator(null));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripFirstLeadingSeparator((String)"foo"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripFirstLeadingSeparator((String)"foo/bar"));
        Assertions.assertEquals((Object)"foo/", (Object)FileUtil.stripFirstLeadingSeparator((String)"foo/"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripFirstLeadingSeparator((String)"/foo/bar"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.stripFirstLeadingSeparator((String)"//foo/bar"));
        Assertions.assertEquals((Object)"//foo/bar", (Object)FileUtil.stripFirstLeadingSeparator((String)"///foo/bar"));
    }

    @Test
    public void testStripTrailingSeparator() {
        Assertions.assertNull((Object)FileUtil.stripTrailingSeparator(null));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripTrailingSeparator((String)"foo"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripTrailingSeparator((String)"foo/bar"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripTrailingSeparator((String)"foo/"));
        Assertions.assertEquals((Object)"foo/bar", (Object)FileUtil.stripTrailingSeparator((String)"foo/bar/"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.stripTrailingSeparator((String)"/foo/bar"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.stripTrailingSeparator((String)"/foo/bar/"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.stripTrailingSeparator((String)"/foo/bar//"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.stripTrailingSeparator((String)"/foo/bar///"));
        Assertions.assertEquals((Object)"/foo", (Object)FileUtil.stripTrailingSeparator((String)"/foo"));
        Assertions.assertEquals((Object)"/foo", (Object)FileUtil.stripTrailingSeparator((String)"/foo/"));
        Assertions.assertEquals((Object)"/", (Object)FileUtil.stripTrailingSeparator((String)"/"));
        Assertions.assertEquals((Object)"//", (Object)FileUtil.stripTrailingSeparator((String)"//"));
    }

    @Test
    public void testStripPath() {
        Assertions.assertNull((Object)FileUtil.stripPath(null));
        Assertions.assertEquals((Object)"", (Object)FileUtil.stripPath((String)"/"));
        Assertions.assertEquals((Object)"foo.xml", (Object)FileUtil.stripPath((String)"/foo.xml"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripPath((String)"foo"));
        Assertions.assertEquals((Object)"bar", (Object)FileUtil.stripPath((String)"foo/bar"));
        Assertions.assertEquals((Object)"bar", (Object)FileUtil.stripPath((String)"/foo/bar"));
    }

    @Test
    public void testStripPathWithMixedSeparators() {
        Assertions.assertNull((Object)FileUtil.stripPath(null));
        Assertions.assertEquals((Object)"", (Object)FileUtil.stripPath((String)"/"));
        Assertions.assertEquals((Object)"foo.xml", (Object)FileUtil.stripPath((String)"/foo.xml"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripPath((String)"foo"));
        Assertions.assertEquals((Object)"baz", (Object)FileUtil.stripPath((String)"foo/bar\\baz"));
        Assertions.assertEquals((Object)"bar", (Object)FileUtil.stripPath((String)"\\foo\\bar"));
        Assertions.assertEquals((Object)"baz", (Object)FileUtil.stripPath((String)"/foo\\bar/baz"));
    }

    @Test
    public void testStripExt() {
        Assertions.assertNull((Object)FileUtil.stripExt(null));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripExt((String)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.stripExt((String)"foo.xml"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.stripExt((String)"/foo/bar.xml"));
    }

    @Test
    public void testOnlyExt() {
        Assertions.assertNull((Object)FileUtil.onlyExt(null));
        Assertions.assertNull((Object)FileUtil.onlyExt((String)"foo"));
        Assertions.assertEquals((Object)"xml", (Object)FileUtil.onlyExt((String)"foo.xml"));
        Assertions.assertEquals((Object)"xml", (Object)FileUtil.onlyExt((String)"/foo/bar.xml"));
        Assertions.assertEquals((Object)"tar.gz", (Object)FileUtil.onlyExt((String)"/foo/bigfile.tar.gz"));
        Assertions.assertEquals((Object)"tar.gz", (Object)FileUtil.onlyExt((String)"/foo.bar/bigfile.tar.gz"));
    }

    @Test
    public void testOnlyPath() {
        Assertions.assertNull((Object)FileUtil.onlyPath(null));
        Assertions.assertNull((Object)FileUtil.onlyPath((String)"foo"));
        Assertions.assertNull((Object)FileUtil.onlyPath((String)"foo.xml"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.onlyPath((String)"foo/bar.xml"));
        Assertions.assertEquals((Object)"/foo", (Object)FileUtil.onlyPath((String)"/foo/bar.xml"));
        Assertions.assertEquals((Object)"/foo/bar", (Object)FileUtil.onlyPath((String)"/foo/bar/baz.xml"));
        Assertions.assertEquals((Object)"/", (Object)FileUtil.onlyPath((String)"/foo.xml"));
        Assertions.assertEquals((Object)"/bar", (Object)FileUtil.onlyPath((String)"/bar/foo.xml"));
    }

    @Test
    public void testOnlyPathWithMixedSeparators() {
        Assertions.assertNull((Object)FileUtil.onlyPath(null));
        Assertions.assertNull((Object)FileUtil.onlyPath((String)"foo"));
        Assertions.assertNull((Object)FileUtil.onlyPath((String)"foo.xml"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.onlyPath((String)"foo/bar.xml"));
        Assertions.assertEquals((Object)"/foo", (Object)FileUtil.onlyPath((String)"/foo\\bar.xml"));
        Assertions.assertEquals((Object)"\\foo\\bar", (Object)FileUtil.onlyPath((String)"\\foo\\bar/baz.xml"));
        Assertions.assertEquals((Object)"\\", (Object)FileUtil.onlyPath((String)"\\foo.xml"));
        Assertions.assertEquals((Object)"/bar", (Object)FileUtil.onlyPath((String)"/bar\\foo.xml"));
    }

    @Test
    public void testOnlyName() {
        Assertions.assertNull((Object)FileUtil.onlyName(null));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.onlyName((String)"foo"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.onlyName((String)"foo.xml"));
        Assertions.assertEquals((Object)"bar", (Object)FileUtil.onlyName((String)"foo/bar.xml"));
        Assertions.assertEquals((Object)"bar", (Object)FileUtil.onlyName((String)"/foo/bar.xml"));
        Assertions.assertEquals((Object)"baz", (Object)FileUtil.onlyName((String)"/foo/bar/baz.xml"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.onlyName((String)"/foo.xml"));
        Assertions.assertEquals((Object)"foo", (Object)FileUtil.onlyName((String)"/bar/foo.xml"));
    }

    @Test
    public void testCompactPath() {
        Assertions.assertNull((Object)FileUtil.compactPath(null));
        if (FileUtil.isWindows()) {
            Assertions.assertEquals((Object)"..\\foo", (Object)FileUtil.compactPath((String)"..\\foo"));
            Assertions.assertEquals((Object)"..\\..\\foo", (Object)FileUtil.compactPath((String)"..\\..\\foo"));
            Assertions.assertEquals((Object)"..\\..\\foo\\bar", (Object)FileUtil.compactPath((String)"..\\..\\foo\\bar"));
            Assertions.assertEquals((Object)"..\\..\\foo", (Object)FileUtil.compactPath((String)"..\\..\\foo\\bar\\.."));
            Assertions.assertEquals((Object)"foo", (Object)FileUtil.compactPath((String)"foo"));
            Assertions.assertEquals((Object)"bar", (Object)FileUtil.compactPath((String)"foo\\..\\bar"));
            Assertions.assertEquals((Object)"bar\\baz", (Object)FileUtil.compactPath((String)"foo\\..\\bar\\baz"));
            Assertions.assertEquals((Object)"foo\\baz", (Object)FileUtil.compactPath((String)"foo\\bar\\..\\baz"));
            Assertions.assertEquals((Object)"baz", (Object)FileUtil.compactPath((String)"foo\\bar\\..\\..\\baz"));
            Assertions.assertEquals((Object)"..\\baz", (Object)FileUtil.compactPath((String)"foo\\bar\\..\\..\\..\\baz"));
            Assertions.assertEquals((Object)"..\\foo\\bar", (Object)FileUtil.compactPath((String)"..\\foo\\bar"));
            Assertions.assertEquals((Object)"foo\\bar\\baz", (Object)FileUtil.compactPath((String)"foo\\bar\\.\\baz"));
            Assertions.assertEquals((Object)"foo\\bar\\baz", (Object)FileUtil.compactPath((String)"foo\\bar\\\\baz"));
            Assertions.assertEquals((Object)"\\foo\\bar\\baz", (Object)FileUtil.compactPath((String)"\\foo\\bar\\baz"));
            Assertions.assertEquals((Object)"\\\\foo\\bar\\baz", (Object)FileUtil.compactPath((String)"\\\\foo\\bar\\baz"));
            Assertions.assertEquals((Object)"\\", (Object)FileUtil.compactPath((String)"\\"));
            Assertions.assertEquals((Object)"\\", (Object)FileUtil.compactPath((String)"/"));
            Assertions.assertEquals((Object)"/", (Object)FileUtil.compactPath((String)"\\", (char)'/'));
            Assertions.assertEquals((Object)"/", (Object)FileUtil.compactPath((String)"/", (char)'/'));
        } else {
            Assertions.assertEquals((Object)"../foo", (Object)FileUtil.compactPath((String)"../foo"));
            Assertions.assertEquals((Object)"../../foo", (Object)FileUtil.compactPath((String)"../../foo"));
            Assertions.assertEquals((Object)"../../foo/bar", (Object)FileUtil.compactPath((String)"../../foo/bar"));
            Assertions.assertEquals((Object)"../../foo", (Object)FileUtil.compactPath((String)"../../foo/bar/.."));
            Assertions.assertEquals((Object)"foo", (Object)FileUtil.compactPath((String)"foo"));
            Assertions.assertEquals((Object)"bar", (Object)FileUtil.compactPath((String)"foo/../bar"));
            Assertions.assertEquals((Object)"bar/baz", (Object)FileUtil.compactPath((String)"foo/../bar/baz"));
            Assertions.assertEquals((Object)"foo/baz", (Object)FileUtil.compactPath((String)"foo/bar/../baz"));
            Assertions.assertEquals((Object)"baz", (Object)FileUtil.compactPath((String)"foo/bar/../../baz"));
            Assertions.assertEquals((Object)"../baz", (Object)FileUtil.compactPath((String)"foo/bar/../../../baz"));
            Assertions.assertEquals((Object)"../foo/bar", (Object)FileUtil.compactPath((String)"../foo/bar"));
            Assertions.assertEquals((Object)"foo/bar/baz", (Object)FileUtil.compactPath((String)"foo/bar/./baz"));
            Assertions.assertEquals((Object)"foo/bar/baz", (Object)FileUtil.compactPath((String)"foo/bar//baz"));
            Assertions.assertEquals((Object)"/foo/bar/baz", (Object)FileUtil.compactPath((String)"/foo/bar/baz"));
            Assertions.assertEquals((Object)"/foo/bar/baz", (Object)FileUtil.compactPath((String)"//foo/bar/baz"));
            Assertions.assertEquals((Object)"/", (Object)FileUtil.compactPath((String)"/"));
            Assertions.assertEquals((Object)"/", (Object)FileUtil.compactPath((String)"\\"));
            Assertions.assertEquals((Object)"/", (Object)FileUtil.compactPath((String)"/", (char)'/'));
            Assertions.assertEquals((Object)"/", (Object)FileUtil.compactPath((String)"\\", (char)'/'));
        }
    }

    @Test
    public void testCompactWindowsStylePath() {
        String path = "E:\\workspace\\foo\\bar\\some-thing\\.\\target\\processes\\2";
        String expected = "E:\\workspace\\foo\\bar\\some-thing\\target\\processes\\2";
        Assertions.assertEquals((Object)expected, (Object)FileUtil.compactPath((String)path, (char)'\\'));
    }

    @Test
    public void testCompactPathSeparator() {
        Assertions.assertNull((Object)FileUtil.compactPath(null, (char)'\''));
        Assertions.assertEquals((Object)"..\\foo", (Object)FileUtil.compactPath((String)"..\\foo", (char)'\\'));
        Assertions.assertEquals((Object)"../foo", (Object)FileUtil.compactPath((String)"../foo", (char)'/'));
        Assertions.assertEquals((Object)"../foo/bar", (Object)FileUtil.compactPath((String)"../foo\\bar", (char)'/'));
        Assertions.assertEquals((Object)"..\\foo\\bar", (Object)FileUtil.compactPath((String)"../foo\\bar", (char)'\\'));
    }

    @Test
    public void testDefaultTempFileSuffixAndPrefix() throws Exception {
        File tmp = FileUtil.createTempFile((String)"tmp-", (String)".tmp", (File)this.testDirectory("tmp").toFile());
        Assertions.assertNotNull((Object)tmp);
        Assertions.assertTrue((boolean)tmp.isFile(), (String)"Should be a file");
    }

    @Test
    public void testDefaultTempFile() throws Exception {
        File tmp = FileUtil.createTempFile(null, null, (File)this.testDirectory("tmp").toFile());
        Assertions.assertNotNull((Object)tmp);
        Assertions.assertTrue((boolean)tmp.isFile(), (String)"Should be a file");
    }

    @Test
    public void testDefaultTempFileParent() throws Exception {
        File tmp = FileUtil.createTempFile(null, null, (File)this.testDirectory().toFile());
        Assertions.assertNotNull((Object)tmp);
        Assertions.assertTrue((boolean)tmp.isFile(), (String)"Should be a file");
    }

    @Test
    public void testCreateNewFile() throws Exception {
        File file = this.testFile("foo.txt").toFile();
        if (file.exists()) {
            FileUtil.deleteFile((File)file);
        }
        Assertions.assertFalse((boolean)file.exists(), (String)("File should not exist " + String.valueOf(file)));
        Assertions.assertTrue((boolean)FileUtil.createNewFile((File)file), (String)("A new file should be created " + String.valueOf(file)));
    }

    @Test
    public void testRenameUsingDelete() throws Exception {
        File file = this.testFile("foo.txt").toFile();
        if (!file.exists()) {
            FileUtil.createNewFile((File)file);
        }
        File target = this.testFile("bar.txt").toFile();
        FileUtil.renameFileUsingCopy((File)file, (File)target);
        Assertions.assertTrue((boolean)target.exists(), (String)"File not copied");
        Assertions.assertFalse((boolean)file.exists(), (String)"File not deleted");
    }

    @Test
    public void testCompactHttpPath() {
        String in = "http://foo.com/apps/func/schemas/part/myap/dummy-schema.xsd";
        String out = FileUtil.compactPath((String)in, (String)"/");
        Assertions.assertEquals((Object)in, (Object)out);
    }

    @Test
    public void testCompactHttpsPath() {
        String in = "https://foo.com/apps/func/schemas/part/myap/dummy-schema.xsd";
        String out = FileUtil.compactPath((String)in, (String)"/");
        Assertions.assertEquals((Object)in, (Object)out);
    }

    @Test
    public void testCompactFilePath() {
        if (FileUtil.isWindows()) {
            Assertions.assertEquals((Object)"file:..\\foo", (Object)FileUtil.compactPath((String)"file:..\\foo"));
            Assertions.assertEquals((Object)"file:..\\..\\foo", (Object)FileUtil.compactPath((String)"file:..\\..\\foo"));
            Assertions.assertEquals((Object)"file:..\\..\\foo\\bar", (Object)FileUtil.compactPath((String)"file:..\\..\\foo\\bar"));
            Assertions.assertEquals((Object)"file:..\\..\\foo", (Object)FileUtil.compactPath((String)"file:..\\..\\foo\\bar\\.."));
            Assertions.assertEquals((Object)"file:foo", (Object)FileUtil.compactPath((String)"file:foo"));
            Assertions.assertEquals((Object)"file:bar", (Object)FileUtil.compactPath((String)"file:foo\\..\\bar"));
            Assertions.assertEquals((Object)"file:bar\\baz", (Object)FileUtil.compactPath((String)"file:foo\\..\\bar\\baz"));
            Assertions.assertEquals((Object)"file:foo\\baz", (Object)FileUtil.compactPath((String)"file:foo\\bar\\..\\baz"));
            Assertions.assertEquals((Object)"file:baz", (Object)FileUtil.compactPath((String)"file:foo\\bar\\..\\..\\baz"));
            Assertions.assertEquals((Object)"file:..\\baz", (Object)FileUtil.compactPath((String)"file:foo\\bar\\..\\..\\..\\baz"));
            Assertions.assertEquals((Object)"file:..\\foo\\bar", (Object)FileUtil.compactPath((String)"file:..\\foo\\bar"));
            Assertions.assertEquals((Object)"file:foo\\bar\\baz", (Object)FileUtil.compactPath((String)"file:foo\\bar\\.\\baz"));
            Assertions.assertEquals((Object)"file:foo\\bar\\baz", (Object)FileUtil.compactPath((String)"file:foo\\bar\\\\baz"));
            Assertions.assertEquals((Object)"file:\\foo\\bar\\baz", (Object)FileUtil.compactPath((String)"file:\\foo\\bar\\baz"));
        } else {
            Assertions.assertEquals((Object)"file:../foo", (Object)FileUtil.compactPath((String)"file:../foo"));
            Assertions.assertEquals((Object)"file:../../foo", (Object)FileUtil.compactPath((String)"file:../../foo"));
            Assertions.assertEquals((Object)"file:../../foo/bar", (Object)FileUtil.compactPath((String)"file:../../foo/bar"));
            Assertions.assertEquals((Object)"file:../../foo", (Object)FileUtil.compactPath((String)"file:../../foo/bar/.."));
            Assertions.assertEquals((Object)"file:foo", (Object)FileUtil.compactPath((String)"file:foo"));
            Assertions.assertEquals((Object)"file:bar", (Object)FileUtil.compactPath((String)"file:foo/../bar"));
            Assertions.assertEquals((Object)"file:bar/baz", (Object)FileUtil.compactPath((String)"file:foo/../bar/baz"));
            Assertions.assertEquals((Object)"file:foo/baz", (Object)FileUtil.compactPath((String)"file:foo/bar/../baz"));
            Assertions.assertEquals((Object)"file:baz", (Object)FileUtil.compactPath((String)"file:foo/bar/../../baz"));
            Assertions.assertEquals((Object)"file:../baz", (Object)FileUtil.compactPath((String)"file:foo/bar/../../../baz"));
            Assertions.assertEquals((Object)"file:../foo/bar", (Object)FileUtil.compactPath((String)"file:../foo/bar"));
            Assertions.assertEquals((Object)"file:foo/bar/baz", (Object)FileUtil.compactPath((String)"file:foo/bar/./baz"));
            Assertions.assertEquals((Object)"file:foo/bar/baz", (Object)FileUtil.compactPath((String)"file:foo/bar//baz"));
            Assertions.assertEquals((Object)"file:/foo/bar/baz", (Object)FileUtil.compactPath((String)"file:/foo/bar/baz"));
        }
    }

    @BeforeEach
    void createTestDir() throws IOException {
        Files.createDirectories(this.testDirectory(), new FileAttribute[0]);
    }
}

