/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.FilePathResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.ResourceLock;

public class FilePathResolverTest {
    @Test
    @ResourceLock(value="java.lang.System.properties")
    public void testFilePathResolver() {
        Assertions.assertEquals((Object)"/foo/bar", (Object)FilePathResolver.resolvePath((String)"/foo/bar"));
        Assertions.assertEquals((Object)"/foo/myserver/bar", (Object)FilePathResolver.resolvePath((String)"/foo/${env:FOO_SERVICE_HOST}/bar"));
        Assertions.assertEquals((Object)"/foo/myserver/bar", (Object)FilePathResolver.resolvePath((String)"/foo/${env.FOO_SERVICE_HOST}/bar"));
        String tmp = System.getProperty("java.io.tmpdir");
        Assertions.assertEquals((Object)(tmp + "foo"), (Object)FilePathResolver.resolvePath((String)"${java.io.tmpdir}foo"));
        System.setProperty("beer", "Carlsberg");
        Assertions.assertEquals((Object)(tmp + "foo/Carlsberg"), (Object)FilePathResolver.resolvePath((String)"${java.io.tmpdir}foo/${beer}"));
        Assertions.assertEquals((Object)("/myprefix/" + tmp + "bar/Carlsberg"), (Object)FilePathResolver.resolvePath((String)"/myprefix/${java.io.tmpdir}bar/${beer}"));
        Assertions.assertEquals((Object)"/foo/myserver/bar/Carlsberg", (Object)FilePathResolver.resolvePath((String)"/foo/${env:FOO_SERVICE_HOST}/bar/${beer}"));
        Assertions.assertEquals((Object)"/foo/myserver/bar/Carlsberg", (Object)FilePathResolver.resolvePath((String)"/foo/${env.FOO_SERVICE_HOST}/bar/${beer}"));
    }
}

