/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.NoSuchPropertyException;
import org.apache.camel.converter.stream.InputStreamCache;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.support.DefaultExchange;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExchangeHelperTest
extends ContextTestSupport {
    protected Exchange exchange;

    @Test
    public void testGetDummy() {
        Exchange one = ExchangeHelper.getDummy((CamelContext)this.context);
        Exchange two = ExchangeHelper.getDummy((CamelContext)this.context);
        Assertions.assertSame((Object)one, (Object)two);
        Assertions.assertNotSame((Object)this.exchange, (Object)one);
        Assertions.assertNotSame((Object)this.exchange, (Object)two);
    }

    @Test
    public void testValidProperty() throws Exception {
        String value = (String)ExchangeHelper.getMandatoryProperty((Exchange)this.exchange, (String)"foo", String.class);
        Assertions.assertEquals((Object)"123", (Object)value, (String)"foo property");
    }

    @Test
    public void testMissingProperty() {
        try {
            String value = (String)ExchangeHelper.getMandatoryProperty((Exchange)this.exchange, (String)"bar", String.class);
            Assertions.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchPropertyException e) {
            Assertions.assertEquals((Object)"bar", (Object)e.getPropertyName());
        }
    }

    @Test
    public void testPropertyOfIncompatibleType() {
        try {
            List value = (List)ExchangeHelper.getMandatoryProperty((Exchange)this.exchange, (String)"foo", List.class);
            Assertions.fail((String)("Should have failed but got: " + String.valueOf(value)));
        }
        catch (NoSuchPropertyException e) {
            Assertions.assertEquals((Object)"foo", (Object)e.getPropertyName());
        }
    }

    @Test
    public void testMissingHeader() {
        try {
            String value = (String)ExchangeHelper.getMandatoryHeader((Exchange)this.exchange, (String)"unknown", String.class);
            Assertions.fail((String)("Should have failed but got: " + value));
        }
        catch (NoSuchHeaderException e) {
            Assertions.assertEquals((Object)"unknown", (Object)e.getHeaderName());
        }
    }

    @Test
    public void testHeaderOfIncompatibleType() {
        this.exchange.getIn().setHeader("foo", (Object)123);
        try {
            List value = (List)ExchangeHelper.getMandatoryHeader((Exchange)this.exchange, (String)"foo", List.class);
            Assertions.fail((String)("Should have failed but got: " + String.valueOf(value)));
        }
        catch (NoSuchHeaderException e) {
            Assertions.assertEquals((Object)"foo", (Object)e.getHeaderName());
        }
    }

    @Test
    public void testNoSuchBean() {
        try {
            ExchangeHelper.lookupMandatoryBean((Exchange)this.exchange, (String)"foo");
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchBeanException e) {
            Assertions.assertEquals((Object)"No bean could be found in the registry for: foo", (Object)e.getMessage());
            Assertions.assertEquals((Object)"foo", (Object)e.getName());
        }
    }

    @Test
    public void testNoSuchBeanType() {
        try {
            ExchangeHelper.lookupMandatoryBean((Exchange)this.exchange, (String)"foo", String.class);
            Assertions.fail((String)"Should have thrown an exception");
        }
        catch (NoSuchBeanException e) {
            Assertions.assertEquals((Object)"No bean could be found in the registry for: foo", (Object)e.getMessage());
            Assertions.assertEquals((Object)"foo", (Object)e.getName());
        }
    }

    @Test
    public void testPopulateVariableMapBodyAndHeaderOnly() {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getMessage().setBody((Object)"bar");
        this.exchange.getMessage().setHeader("quote", (Object)"Camel rocks");
        HashMap map = new HashMap();
        ExchangeHelper.populateVariableMap((Exchange)this.exchange, map, (boolean)false);
        Assertions.assertEquals((int)6, (int)map.size());
        Assertions.assertNull(map.get("exchange"));
        Assertions.assertNull(map.get("in"));
        Assertions.assertNull(map.get("request"));
        Assertions.assertNull(map.get("out"));
        Assertions.assertNull(map.get("response"));
        Assertions.assertNull(map.get("exception"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("header"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        Assertions.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        Assertions.assertSame((Object)this.exchange.getVariable("cheese"), map.get("cheese"));
        Assertions.assertNull(map.get("camelContext"));
    }

    @Test
    public void testPopulateVariableMap() {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getMessage().setBody((Object)"bar");
        this.exchange.getMessage().setHeader("quote", (Object)"Camel rocks");
        HashMap map = new HashMap();
        ExchangeHelper.populateVariableMap((Exchange)this.exchange, map, (boolean)true);
        Assertions.assertEquals((int)14, (int)map.size());
        Assertions.assertSame((Object)this.exchange, map.get("exchange"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("in"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("request"));
        Assertions.assertSame((Object)this.exchange.getMessage(), map.get("out"));
        Assertions.assertSame((Object)this.exchange.getMessage(), map.get("response"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("header"));
        Assertions.assertSame((Object)this.exchange.getVariables(), map.get("variable"));
        Assertions.assertSame((Object)this.exchange.getVariables(), map.get("variables"));
        Assertions.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        Assertions.assertSame((Object)this.exchange.getContext(), map.get("camelContext"));
    }

    @Test
    public void testCreateVariableMap() {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getMessage().setBody((Object)"bar");
        this.exchange.getMessage().setHeader("quote", (Object)"Camel rocks");
        this.exchange.setVariable("cheese", (Object)"gauda");
        Map map = ExchangeHelper.createVariableMap((Exchange)this.exchange, (boolean)true);
        Assertions.assertEquals((int)14, (int)map.size());
        Assertions.assertSame((Object)this.exchange, map.get("exchange"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("in"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("request"));
        Assertions.assertSame((Object)this.exchange.getMessage(), map.get("out"));
        Assertions.assertSame((Object)this.exchange.getMessage(), map.get("response"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("header"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        Assertions.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        Assertions.assertSame((Object)this.exchange.getContext(), map.get("camelContext"));
    }

    @Test
    public void testCreateVariableMapNoExistingOut() {
        this.exchange.setPattern(ExchangePattern.InOut);
        this.exchange.getIn().setBody((Object)"bar");
        this.exchange.getIn().setHeader("quote", (Object)"Camel rocks");
        Assertions.assertFalse((boolean)this.exchange.hasOut());
        Map map = ExchangeHelper.createVariableMap((Exchange)this.exchange, (boolean)true);
        Assertions.assertEquals((int)14, (int)map.size());
        Assertions.assertSame((Object)this.exchange, map.get("exchange"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("in"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("request"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("out"));
        Assertions.assertSame((Object)this.exchange.getIn(), map.get("response"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("header"));
        Assertions.assertSame((Object)this.exchange.getIn().getHeaders(), map.get("headers"));
        Assertions.assertSame((Object)this.exchange.getIn().getBody(), map.get("body"));
        Assertions.assertSame((Object)this.exchange.getVariable("cheese"), map.get("cheese"));
        Assertions.assertSame((Object)this.exchange.getContext(), map.get("camelContext"));
        Assertions.assertFalse((boolean)this.exchange.hasOut());
    }

    @Test
    public void testGetContentType() {
        this.exchange.getIn().setHeader("Content-Type", (Object)"text/xml");
        Assertions.assertEquals((Object)"text/xml", (Object)ExchangeHelper.getContentType((Exchange)this.exchange));
    }

    @Test
    public void testGetContentEncoding() {
        this.exchange.getIn().setHeader("Content-Encoding", (Object)"iso-8859-1");
        Assertions.assertEquals((Object)"iso-8859-1", (Object)ExchangeHelper.getContentEncoding((Exchange)this.exchange));
    }

    @Test
    public void testIsStreamCaching() {
        Assertions.assertFalse((boolean)ExchangeHelper.isStreamCachingEnabled((Exchange)this.exchange));
        this.exchange.getContext().getStreamCachingStrategy().setEnabled(true);
        Assertions.assertTrue((boolean)ExchangeHelper.isStreamCachingEnabled((Exchange)this.exchange));
    }

    @Test
    public void testGetBodyAndResetStreamCache() {
        InputStreamCache body = new InputStreamCache("Hello Camel Rider!".getBytes(StandardCharsets.UTF_8));
        this.exchange.getMessage().setBody((Object)body);
        String first = (String)ExchangeHelper.getBodyAndResetStreamCache((Exchange)this.exchange, String.class);
        String second = (String)ExchangeHelper.getBodyAndResetStreamCache((Exchange)this.exchange, String.class);
        Assertions.assertFalse((boolean)ObjectHelper.isEmpty((String)second), (String)"second should not be null or empty");
        Assertions.assertEquals((Object)first, (Object)second);
        this.exchange.getMessage().setBody(null);
        String third = (String)ExchangeHelper.getBodyAndResetStreamCache((Exchange)this.exchange, String.class);
        Assertions.assertNull((Object)third);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());
        this.exchange.setProperty("foo", (Object)123);
    }
}

