/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.support.EventNotifierSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EventHelperTest {
    @Test
    public void testStartStopEventsReceived() throws Exception {
        MyEventNotifier en1 = new MyEventNotifier();
        MyEventNotifier en2 = new MyEventNotifier();
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("route-1").to("mock:end");
            }
        });
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en1);
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en2);
        camelContext.start();
        camelContext.stop();
        Assertions.assertEquals((int)1, (int)en1.routeStartedEvent.get());
        Assertions.assertEquals((int)1, (int)en1.routeStoppedEvent.get());
        Assertions.assertEquals((int)1, (int)en1.camelContextStoppingEvent.get());
        Assertions.assertEquals((int)1, (int)en2.routeStartedEvent.get());
        Assertions.assertEquals((int)1, (int)en2.routeStoppedEvent.get());
        Assertions.assertEquals((int)1, (int)en2.camelContextStoppingEvent.get());
    }

    @Test
    public void testStartStopEventsReceivedWhenTheFirstOneIgnoreTheseEvents() throws Exception {
        MyEventNotifier en1 = new MyEventNotifier();
        en1.setIgnoreRouteEvents(true);
        en1.setIgnoreCamelContextEvents(true);
        MyEventNotifier en2 = new MyEventNotifier();
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("route-1").to("mock:end");
            }
        });
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en1);
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en2);
        camelContext.start();
        camelContext.stop();
        Assertions.assertEquals((int)0, (int)en1.routeStartedEvent.get());
        Assertions.assertEquals((int)0, (int)en1.routeStoppedEvent.get());
        Assertions.assertEquals((int)0, (int)en1.camelContextStoppingEvent.get());
        Assertions.assertEquals((int)1, (int)en2.routeStartedEvent.get());
        Assertions.assertEquals((int)1, (int)en2.routeStoppedEvent.get());
        Assertions.assertEquals((int)1, (int)en2.camelContextStoppingEvent.get());
    }

    @Test
    public void testStartStopEventsReceivedWhenTheSecondOneIgnoreTheseEvents() throws Exception {
        MyEventNotifier en1 = new MyEventNotifier();
        MyEventNotifier en2 = new MyEventNotifier();
        en2.setIgnoreRouteEvents(true);
        en2.setIgnoreCamelContextEvents(true);
        DefaultCamelContext camelContext = new DefaultCamelContext();
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("route-1").to("mock:end");
            }
        });
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en1);
        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)en2);
        camelContext.start();
        camelContext.stop();
        Assertions.assertEquals((int)1, (int)en1.routeStartedEvent.get());
        Assertions.assertEquals((int)1, (int)en1.routeStoppedEvent.get());
        Assertions.assertEquals((int)1, (int)en1.camelContextStoppingEvent.get());
        Assertions.assertEquals((int)0, (int)en2.routeStartedEvent.get());
        Assertions.assertEquals((int)0, (int)en2.routeStoppedEvent.get());
        Assertions.assertEquals((int)0, (int)en2.camelContextStoppingEvent.get());
    }

    static class MyEventNotifier
    extends EventNotifierSupport {
        final AtomicInteger routeStartedEvent = new AtomicInteger();
        final AtomicInteger routeStoppedEvent = new AtomicInteger();
        final AtomicInteger camelContextStoppingEvent = new AtomicInteger();

        MyEventNotifier() {
        }

        public void notify(CamelEvent event) {
            if (event.getType() == CamelEvent.Type.RouteStarted) {
                this.routeStartedEvent.incrementAndGet();
            } else if (event.getType() == CamelEvent.Type.RouteStopped) {
                this.routeStoppedEvent.incrementAndGet();
            } else if (event.getType() == CamelEvent.Type.CamelContextStopping) {
                this.camelContextStoppingEvent.incrementAndGet();
            }
        }

        public boolean isEnabled(CamelEvent event) {
            return true;
        }
    }
}

