/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.NamedNode;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.support.EndpointHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EndpointHelperTest
extends ContextTestSupport {
    private Endpoint foo;
    private Endpoint bar;

    @Test
    public void testPollEndpoint() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo", (Object)"Bye World");
        final ArrayList bodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.context.getEndpoint("seda:foo"), (Processor)new Processor(){

            public void process(Exchange exchange) {
                bodies.add((String)exchange.getIn().getBody(String.class));
            }
        });
        Assertions.assertEquals((int)2, (int)bodies.size());
        Assertions.assertEquals((Object)"Hello World", bodies.get(0));
        Assertions.assertEquals((Object)"Bye World", bodies.get(1));
    }

    @Test
    public void testPollEndpointTimeout() throws Exception {
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("seda:foo", (Object)"Bye World");
        final ArrayList bodies = new ArrayList();
        EndpointHelper.pollEndpoint((Endpoint)this.context.getEndpoint("seda:foo"), (Processor)new Processor(){

            public void process(Exchange exchange) {
                bodies.add((String)exchange.getIn().getBody(String.class));
            }
        }, (long)10L);
        Assertions.assertEquals((int)2, (int)bodies.size());
        Assertions.assertEquals((Object)"Hello World", bodies.get(0));
        Assertions.assertEquals((Object)"Bye World", bodies.get(1));
    }

    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        this.foo = context.getEndpoint("mock:foo");
        this.bar = context.getEndpoint("mock:bar");
        context.getRegistry().bind("foo", (Object)this.foo);
        context.getRegistry().bind("coolbar", (Object)this.bar);
        context.getRegistry().bind("numbar", (Object)"12345");
        return context;
    }

    @Test
    public void testLookupEndpointRegistryId() {
        Assertions.assertEquals((Object)"foo", (Object)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.foo));
        Assertions.assertEquals((Object)"coolbar", (Object)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.bar));
        Assertions.assertNull((Object)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.context.getEndpoint("mock:cheese")));
    }

    @Test
    public void testLookupEndpointRegistryIdUsingRef() {
        this.foo = this.context.getEndpoint("ref:foo");
        this.bar = this.context.getEndpoint("ref:coolbar");
        Assertions.assertEquals((Object)"foo", (Object)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.foo));
        Assertions.assertEquals((Object)"coolbar", (Object)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.bar));
        Assertions.assertNull((Object)EndpointHelper.lookupEndpointRegistryId((Endpoint)this.context.getEndpoint("mock:cheese")));
    }

    @Test
    public void testResolveReferenceParameter() {
        Endpoint endpoint = (Endpoint)EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"coolbar", Endpoint.class);
        Assertions.assertNotNull((Object)endpoint);
        Assertions.assertSame((Object)this.bar, (Object)endpoint);
    }

    @Test
    public void testResolveAndConvertReferenceParameter() {
        Integer number = (Integer)EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"numbar", Integer.class);
        Assertions.assertNotNull((Object)number);
        Assertions.assertEquals((int)12345, (int)number);
    }

    @Test
    public void testResolveAndConvertMissingReferenceParameter() {
        Integer number = (Integer)EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"misbar", Integer.class, (boolean)false);
        Assertions.assertNull((Object)number);
    }

    @Test
    public void testMandatoryResolveAndConvertMissingReferenceParameter() {
        try {
            EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"misbar", Integer.class, (boolean)true);
            Assertions.fail();
        }
        catch (NoSuchBeanException ex) {
            Assertions.assertEquals((Object)"No bean could be found in the registry for: misbar of type: java.lang.Integer", (Object)ex.getMessage());
        }
    }

    @Test
    public void testResolveParameter() {
        Endpoint endpoint = (Endpoint)EndpointHelper.resolveParameter((CamelContext)this.context, (String)"#coolbar", Endpoint.class);
        Assertions.assertNotNull((Object)endpoint);
        Assertions.assertSame((Object)this.bar, (Object)endpoint);
        Integer num = (Integer)EndpointHelper.resolveParameter((CamelContext)this.context, (String)"123", Integer.class);
        Assertions.assertNotNull((Object)num);
        Assertions.assertEquals((int)123, (int)num);
    }

    @Test
    public void matchEndpointsShouldIgnoreQueryParamOrder() {
        String endpointUri = "sjms:queue:my-queue?transacted=true&consumerCount=1";
        String endpointUriShuffled = "sjms:queue:my-queue?consumerCount=1&transacted=true";
        String notMatchingEndpointUri = "sjms:queue:my-queue?consumerCount=1";
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUri, (String)endpointUri), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUri, (String)endpointUriShuffled), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUriShuffled, (String)endpointUri), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUriShuffled, (String)endpointUriShuffled), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)notMatchingEndpointUri, (String)endpointUriShuffled), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)notMatchingEndpointUri, (String)endpointUri), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUri, (String)notMatchingEndpointUri), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUriShuffled, (String)notMatchingEndpointUri), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void matchEndpointsShouldMatchWildcards() {
        String endpointUri = "sjms:queue:my-queue?transacted=true&consumerCount=1";
        String notMatchingEndpointUri = "sjms:queue:my-queue";
        String pattern = "sjms:queue:my-queue?*";
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUri, (String)pattern), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)notMatchingEndpointUri, (String)pattern), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void matchEndpointsShouldMatchRegex() {
        String endpointUri = "sjms:queue:my-queue?transacted=true&consumerCount=1";
        String notMatchingEndpointUri = "sjms:queue:my-queue?transacted=false&consumerCount=1";
        String pattern = "sjms://.*transacted=true.*";
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)endpointUri, (String)pattern), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)EndpointHelper.matchEndpoint(null, (String)notMatchingEndpointUri, (String)pattern), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testResolveByType() {
        AuthorizationPolicy myPolicy = new AuthorizationPolicy(){

            public void beforeWrap(Route route, NamedNode definition) {
            }

            public Processor wrap(Route route, Processor processor) {
                return processor;
            }
        };
        this.context.getRegistry().bind("foobar", (Object)myPolicy);
        AuthorizationPolicy policy = (AuthorizationPolicy)EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"#type:org.apache.camel.spi.AuthorizationPolicy", AuthorizationPolicy.class);
        Assertions.assertNotNull((Object)policy);
        Assertions.assertSame((Object)myPolicy, (Object)policy);
    }

    @Test
    public void testResolveByTypeNoBean() {
        try {
            EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"#type:org.apache.camel.spi.AuthorizationPolicy", AuthorizationPolicy.class);
            Assertions.fail((String)"Should throw exception");
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
    }

    @Test
    public void testResolveByTypeTwo() {
        AuthorizationPolicy myPolicy = new AuthorizationPolicy(){

            public void beforeWrap(Route route, NamedNode definition) {
            }

            public Processor wrap(Route route, Processor processor) {
                return processor;
            }
        };
        this.context.getRegistry().bind("foobar", (Object)myPolicy);
        AuthorizationPolicy myPolicy2 = new AuthorizationPolicy(){

            public void beforeWrap(Route route, NamedNode definition) {
            }

            public Processor wrap(Route route, Processor processor) {
                return processor;
            }
        };
        this.context.getRegistry().bind("foobar2", (Object)myPolicy2);
        try {
            EndpointHelper.resolveReferenceParameter((CamelContext)this.context, (String)"#type:org.apache.camel.spi.AuthorizationPolicy", AuthorizationPolicy.class);
            Assertions.fail((String)"Should throw exception");
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
    }
}

