/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.DumpModelAsYamlTestSupport;
import org.apache.camel.util.IOHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpModelAsYamlTransformRouteTest
extends DumpModelAsYamlTestSupport {
    @Test
    public void testDumpModelAsYaml() throws Exception {
        String out = PluginHelper.getModelToYAMLDumper((CamelContext)this.context).dumpModelAsYaml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        String expected = IOHelper.stripLineComments((Path)Paths.get("src/test/resources/org/apache/camel/util/transform.yaml", new String[0]), (String)"#", (boolean)true);
        Assertions.assertEquals((Object)expected, (Object)out);
    }

    @Test
    public void testDumpModelAsYamlUriAsParameters() throws Exception {
        String out = PluginHelper.getModelToYAMLDumper((CamelContext)this.context).dumpModelAsYaml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"), true, true, true);
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        String expected = IOHelper.stripLineComments((Path)Paths.get("src/test/resources/org/apache/camel/util/transform2.yaml", new String[0]), (String)"#", (boolean)true);
        Assertions.assertEquals((Object)expected, (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:start?exchangePattern=InOnly").routeId("myRoute").transform().simple("Hello ${body}")).to("mock:result?failFast=false&retainFirst=5&browseLimit=123")).id("myMock");
            }
        };
    }
}

