/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.DumpModelAsYamlTestSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpModelAsYamlTransformChoiceRouteTest
extends DumpModelAsYamlTestSupport {
    @Test
    public void testDumpModelAsXml() throws Exception {
        String xml = PluginHelper.getModelToXMLDumper((CamelContext)this.context).dumpModelAsXml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)xml);
        this.log.info(xml);
        String expected = IOHelper.stripLineComments((Path)Paths.get("src/test/resources/org/apache/camel/util/transform3.xml", new String[0]), (String)"#", (boolean)true);
        expected = StringHelper.after((String)expected, (String)"-->");
        Assertions.assertEquals((Object)expected, (Object)("\n" + xml + "\n"));
    }

    @Test
    public void testDumpModelAsYaml() throws Exception {
        String out = PluginHelper.getModelToYAMLDumper((CamelContext)this.context).dumpModelAsYaml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)out);
        this.log.info(out);
        String expected = IOHelper.stripLineComments((Path)Paths.get("src/test/resources/org/apache/camel/util/transform3.yaml", new String[0]), (String)"#", (boolean)true);
        Assertions.assertEquals((Object)expected, (Object)out);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ProcessorDefinition)this.from("timer:java?period={{time:1000}}").routeId("myRoute").setBody().simple("Hello Camel from ${routeId}")).choice().when((Predicate)this.simple("${header.foo} == 'bar'")).to("direct:bar")).when((Predicate)this.simple("${header.foo} == 'cake'")).to("direct:cake")).otherwise().to("direct:cheese")).end().log("${body}");
            }
        };
    }
}

