/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.CamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.DumpModelAsYamlTestSupport;
import org.apache.camel.util.MyCoolRoute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DumpModelAsYamlSourceLocationTest
extends DumpModelAsYamlTestSupport {
    @Override
    protected CamelContext createCamelContext() throws Exception {
        CamelContext context = super.createCamelContext();
        context.setDebugging(Boolean.valueOf(true));
        return context;
    }

    @Test
    public void testDumpModelAsYaml() throws Exception {
        String yaml = PluginHelper.getModelToYAMLDumper((CamelContext)this.context).dumpModelAsYaml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("myRoute"));
        Assertions.assertNotNull((Object)yaml);
        this.log.info(yaml);
        Assertions.assertTrue((boolean)yaml.contains("sourceLineNumber: 67"));
        Assertions.assertTrue((boolean)yaml.contains("sourceLineNumber: 68"));
        Assertions.assertTrue((boolean)yaml.contains("sourceLineNumber: 69"));
        Assertions.assertTrue((boolean)yaml.contains("sourceLocation: DumpModelAsYamlSourceLocationTest.java"));
    }

    @Test
    public void testDumpModelAsYamlExternal() throws Exception {
        String yaml = PluginHelper.getModelToYAMLDumper((CamelContext)this.context).dumpModelAsYaml((CamelContext)this.context, (NamedNode)this.context.getRouteDefinition("cool"));
        Assertions.assertNotNull((Object)yaml);
        this.log.info(yaml);
        Assertions.assertTrue((boolean)yaml.contains("sourceLineNumber: 25"));
        Assertions.assertTrue((boolean)yaml.contains("sourceLineNumber: 26"));
        Assertions.assertTrue((boolean)yaml.contains("sourceLineNumber: 27"));
        Assertions.assertTrue((boolean)yaml.contains("sourceLocation: MyCoolRoute.java"));
    }

    protected RouteBuilder[] createRouteBuilders() {
        return new RouteBuilder[]{new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("myRoute").filter((Predicate)this.simple("${body} > 10")).to("mock:result");
            }
        }, new MyCoolRoute()};
    }
}

